/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class PostLh2Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int CodeSize = 286;
    private BitOutputStream out;
    private DynamicHuffman codeHuffman;
    private DynamicHuffman offHiHuffman;
    private int position;
    private int nextPosition;
    private int matchLength;

    public PostLh2Encoder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.out = out instanceof BitOutputStream ? (BitOutputStream)out : new BitOutputStream(out);
        this.codeHuffman = new DynamicHuffman(286);
        this.offHiHuffman = new DynamicHuffman(128, 1);
        this.position = 0;
        this.nextPosition = 64;
    }

    @Override
    public void writeCode(int code) throws IOException {
        int CodeMax = 285;
        int node = this.codeHuffman.codeToNode(Math.min(code, 285));
        int hcode = 0;
        int hlen = 0;
        do {
            hcode >>>= 1;
            ++hlen;
            if ((node & 1) == 0) continue;
            hcode |= Integer.MIN_VALUE;
        } while ((node = this.codeHuffman.parentNode(node)) != 0);
        this.out.writeBits(hlen, hcode >>> 32 - hlen);
        if (code < 256) {
            ++this.position;
        } else {
            this.matchLength = (code & 0xFF) + 3;
            if (285 <= code) {
                this.out.writeBits(8, code - 285);
                code = 285;
            }
        }
        this.codeHuffman.update(code);
    }

    @Override
    public void writeOffset(int offset) throws IOException {
        if (this.nextPosition < 8192) {
            while (this.nextPosition < this.position) {
                this.offHiHuffman.addLeaf(this.nextPosition >> 6);
                this.nextPosition += 64;
                if (8192 > this.nextPosition) continue;
            }
        }
        int node = this.offHiHuffman.codeToNode(offset >> 6);
        int hcode = 0;
        int hlen = 0;
        while (node != 0) {
            hcode >>>= 1;
            ++hlen;
            if ((node & 1) != 0) {
                hcode |= Integer.MIN_VALUE;
            }
            node = this.offHiHuffman.parentNode(node);
        }
        this.out.writeBits(hlen, hcode >> 32 - hlen);
        this.out.writeBits(6, offset);
        this.offHiHuffman.update(offset >> 6);
        this.position += this.matchLength;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.out = null;
        this.codeHuffman = null;
        this.offHiHuffman = null;
    }

    @Override
    public int getDictionarySize() {
        return 8192;
    }

    @Override
    public int getMaxMatch() {
        return 256;
    }

    @Override
    public int getThreshold() {
        return 3;
    }
}

