/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh1Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 60;
    private static final int Threshold = 3;
    BitInputStream in;
    DynamicHuffman huffman;
    int[] offHiLen;
    short[] offHiTable;
    int offHiTableBits;
    DynamicHuffman markHuffman;

    public PreLh1Decoder(InputStream in) {
        if (in != null) {
            this.in = in instanceof BitInputStream ? (BitInputStream)in : new BitInputStream(in);
            this.huffman = new DynamicHuffman(314);
            this.markHuffman = null;
            this.offHiLen = PreLh1Decoder.createLenList();
            try {
                this.offHiTable = StaticHuffman.createTable(this.offHiLen);
            }
            catch (BadHuffmanTableException badHuffmanTableException) {
                // empty catch block
            }
        } else {
            throw new NullPointerException("in");
        }
        this.offHiTableBits = Bits.len(this.offHiTable.length - 1);
    }

    @Override
    public int readCode() throws IOException {
        int node = this.huffman.childNode(0);
        while (0 <= node) {
            node = this.huffman.childNode(node - (this.in.readBoolean() ? 1 : 0));
        }
        int code = ~node;
        this.huffman.update(code);
        return code;
    }

    @Override
    public int readOffset() throws IOException {
        short offHi = this.offHiTable[this.in.peekBits(this.offHiTableBits)];
        this.in.skipBits(this.offHiLen[offHi]);
        return offHi << 6 | this.in.readBits(6);
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit * 18 / 8 + 4);
        this.markHuffman = this.huffman.clone();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.huffman = this.markHuffman.clone();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 18 - 4, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.huffman = null;
        this.markHuffman = null;
        this.offHiLen = null;
        this.offHiTable = null;
        this.offHiTableBits = 0;
    }

    @Override
    public int getDictionarySize() {
        return 4096;
    }

    @Override
    public int getMaxMatch() {
        return 60;
    }

    @Override
    public int getThreshold() {
        return 3;
    }

    private static int[] createLenList() {
        int length = 64;
        int[] list = new int[]{3, 1, 4, 12, 24, 48, 0};
        int[] LenList = new int[64];
        int index = 0;
        int len = list[index++];
        for (int i = 0; i < 64; ++i) {
            if (list[index] == i) {
                ++index;
            }
            LenList[i] = ++len;
        }
        return LenList;
    }
}

