/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.ArchivedEntry;
import charactermanaj.model.io.ArchivedFile;
import charactermanaj.model.io.LzhArchivedEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;

class LzhArchivedFile
extends AbstractCollection<LzhArchivedEntry>
implements ArchivedFile<LzhArchivedEntry> {
    protected File archivedFile;
    protected LhaFile lhaFile;
    protected HashMap<String, LzhArchivedEntry> entries = new HashMap();

    public LzhArchivedFile(File archivedFile) throws IOException {
        if (archivedFile == null) {
            throw new IllegalArgumentException();
        }
        this.archivedFile = archivedFile;
        this.lhaFile = new LhaFile(archivedFile);
        this.enumFiles();
    }

    protected void enumFiles() throws IOException {
        Enumeration enm = this.lhaFile.entries();
        while (enm.hasMoreElements()) {
            LhaHeader header = (LhaHeader)enm.nextElement();
            LzhArchivedEntry entry = new LzhArchivedEntry(header);
            this.entries.put(entry.getName(), entry);
        }
    }

    @Override
    public String getName() {
        return this.archivedFile.getPath().replace('\\', '/');
    }

    @Override
    public ArchivedEntry getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public InputStream getInputStream(ArchivedEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        LzhArchivedEntry lhaEntry = this.entries.get(entry.getName());
        if (lhaEntry == null) {
            return null;
        }
        return this.lhaFile.getInputStream(lhaEntry.getLhaHeader());
    }

    @Override
    public void close() throws IOException {
        this.lhaFile.close();
    }

    @Override
    public Iterator<LzhArchivedEntry> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }
}

