/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.ArchivedEntry;
import charactermanaj.model.io.ArchivedFile;
import charactermanaj.model.io.ZipArchivedEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

class ZipArchivedFile
extends AbstractCollection<ZipArchivedEntry>
implements ArchivedFile<ZipArchivedEntry> {
    protected String ZIP_ENCODING = System.getProperty("zip.encoding", "csWindows31J");
    protected File archivedFile;
    protected ZipFile zipFile;
    protected HashMap<String, ZipArchivedEntry> entries = new HashMap();

    public ZipArchivedFile(File archivedFile) throws IOException {
        if (archivedFile == null) {
            throw new IllegalArgumentException();
        }
        this.archivedFile = archivedFile;
        this.zipFile = new ZipFile(archivedFile, this.ZIP_ENCODING);
        this.enumFiles();
    }

    protected void enumFiles() throws IOException {
        Enumeration enm = this.zipFile.getEntries();
        while (enm.hasMoreElements()) {
            ZipEntry header = (ZipEntry)enm.nextElement();
            ZipArchivedEntry entry = new ZipArchivedEntry(header);
            this.entries.put(entry.getName(), entry);
        }
    }

    @Override
    public String getName() {
        return this.archivedFile.getPath().replace('\\', '/');
    }

    @Override
    public ArchivedEntry getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public InputStream getInputStream(ArchivedEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        ZipArchivedEntry lhaEntry = this.entries.get(entry.getName());
        if (lhaEntry == null) {
            return null;
        }
        return this.zipFile.getInputStream(lhaEntry.getZipEntry());
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public Iterator<ZipArchivedEntry> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }
}

