package kisscelltopng;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import kisscelltopng.ui.MainFrame;

/**
 * エントリポイント.<br>
 * @author seraphy
 */
public class Main implements Runnable {

	/**
	 * UIをセットアップする.<br>
	 * 失敗しても継続する.<br>
	 */
	protected void setupLookAndFeel() {
		try {
			// 実行プラットフォームのネイティブな外観にする.
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			
		} catch (Exception ex) {
			// UIのL&Fセットアップに失敗しても継続する
			ex.printStackTrace();
		}
	}

	/**
	 * EDTでUIの初期化とメインフレームの表示を行う.<br>
	 */
	public void run() {
		setupLookAndFeel();

		MainFrame mainFrame = new MainFrame();
		mainFrame.setVisible(true);
	}

	/**
	 * アプリケーションの開始.<br>
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {
		SwingUtilities.invokeLater(new Main());
	}
}
