package kisscelltopng.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;
import javax.swing.JScrollPane;

import kisscelltopng.ui.util.ScrollPaneDragScrollSupport;
import kisscelltopng.ui.util.ScrollPaneDragScrollSupport.DragPridicator;

public class CellPreviewPane extends JPanel {

	private static final long serialVersionUID = 1L;
	
	private BufferedImage img;
	
	private JScrollPane sp;
	
	private JPanel previewPanel = new JPanel() {
		private static final long serialVersionUID = 1L;

		@Override
		protected void paintComponent(Graphics g) {
			super.paintComponent(g);
			if (img != null) {
				int w = img.getWidth();
				int h = img.getHeight();
				g.drawImage(img, 0, 0, w, h, null);
			}
		}
	};

	public void setImage(BufferedImage img) {
		this.img = img;
		if (img == null) {
			previewPanel.setPreferredSize(new Dimension(0, 0));
		
		} else {
			int w = img.getWidth();
			int h = img.getHeight();
			previewPanel.setPreferredSize(new Dimension(w, h));
		}
		previewPanel.revalidate();
		repaint();
	}
	
	public BufferedImage getImage() {
		return this.img;
	}

	public CellPreviewPane() {
		setLayout(new BorderLayout());
		sp = new JScrollPane(previewPanel,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		add(sp, BorderLayout.CENTER);
		
		new ScrollPaneDragScrollSupport(sp).setupListener(previewPanel, new DragPridicator() {
			public boolean isDraggable(MouseEvent e) {
				return true;
			}
		});
	}
	
}
