package kisscelltopng.kiss.io;

import java.io.File;

import kisscelltopng.kiss.types.KiSSCell;

import org.junit.Test;

import charactermanaj.model.io.ArchivedEntry;
import charactermanaj.model.io.ArchivedFile;
import charactermanaj.model.io.ArchivedFileFactory;


public class KiSSFileTest {

	@Test
	public void testLoad() throws Exception {
		File file = new File("../jlha/testdata/yumi_mf0f.lzh");
		ArchivedFile<? extends ArchivedEntry> archivedFile = ArchivedFileFactory.getArchivedFile(file);
		KiSSFile kissFile = new KiSSFile(archivedFile);
		for (String cellName : kissFile.getCellNames()) {
			System.out.println(cellName);
			KiSSCell cell = kissFile.getCell(cellName, false);
			System.out.println(cell.getWidth() + "x" + cell.getHeight());
		}
	}
	
}
