package kisscelltopng.logic;

import java.io.IOException;

import kisscelltopng.ui.model.DirChoosePanelModel.SourceType;

public class DataConverterFactory {

	public DataConverter createDataConverter(SourceType sourceType) throws IOException {
		if (sourceType == SourceType.KISS) {
			return new KiSSDataConverter();
		}
		if (sourceType == SourceType.PNG) {
			return new PNGDataConverter();
		}
		throw new IllegalArgumentException();
	}
	
}
