package kisscelltopng.ui.model;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;

import kisscelltopng.kiss.converter.KiSSCellImageBuilder;
import kisscelltopng.kiss.types.KiSSCell;
import kisscelltopng.kiss.types.KiSSPalette;

public class CellViewPanelModel implements Serializable {

	private static final long serialVersionUID = 7305795369043547043L;

	private File cellFile;
	
	private transient BufferedImage img;
	
	private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	
	private KiSSPalette palette;
	
	private int pageOfPalette;
	
	private KiSSCell cell;
	
	public void setCell(KiSSCell cell) {
		img = null;
		KiSSCell old = this.cell;
		this.cell = cell;
		propertyChangeSupport.firePropertyChange("cell", old, cell);
	}
	
	public void setPageOfPalette(int pageOfPalette) {
		img = null;
		int old = this.pageOfPalette;
		this.pageOfPalette = pageOfPalette;
		propertyChangeSupport.firePropertyChange("pageOfPalette", old, pageOfPalette);
	}

	public void setPalette(KiSSPalette palette) {
		img = null;
		KiSSPalette old = this.palette;
		this.palette = palette;
		propertyChangeSupport.firePropertyChange("palette", old, palette);
	}
	
	public KiSSCell getCell() {
		return cell;
	}
	
	public int getPageOfPalette() {
		return pageOfPalette;
	}
	
	public KiSSPalette getPalette() {
		return palette;
	}
	
	public void setCellFile(File cellFile) {
		File old = this.cellFile;
		this.cellFile = cellFile;
		propertyChangeSupport.firePropertyChange("cellFile", old, cellFile);
	}
	
	public File getCellFile() {
		return cellFile;
	}
	
	public BufferedImage getImg() {
		if (img == null) {
			if (cell != null && (!cell.isIndexedColor() || palette != null)) {
				KiSSCellImageBuilder builder = new KiSSCellImageBuilder();
				builder.setPaletteGroup(pageOfPalette);
				builder.setPalette(palette);
				try {
					img = builder.build(cell);

				} catch (RuntimeException ex) {
					ex.printStackTrace();
				}
			}
		}
		return img;
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}
}