package kisscelltopng.kiss.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class KiSSCellWriter {

	public void write(File file, BufferedImage img) throws IOException {
		if (file == null || img == null) {
			throw new IllegalArgumentException();
		}

		OutputStream os = new BufferedOutputStream(new FileOutputStream(file));
		try {
			write(os, img);
			
		} finally {
			os.close();
		}
	}
	
	public void write(OutputStream os, BufferedImage img) throws IOException {
		if (os == null || img == null) {
			throw new IllegalArgumentException();
		}
		
		// シグネチャ
		os.write("KiSS".getBytes("UTF-8"));
		
		// ckiss形式
		os.write((byte) 0x21);
		
		// bitsPerPixel (32bit)
		os.write((byte) 32);

		// reserve 2byte
		os.write((byte) 0);
		os.write((byte) 0);

		// width, height, offsetX/Y + reserve 16
		short width = (short) img.getWidth();
		short height = (short) img.getHeight();
		short offsetX, offsetY;
		offsetX = offsetY = 0;

		byte[] buf = new byte[8 + 16];
		ByteBuffer bbuf = ByteBuffer.wrap(buf);
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		bbuf.putShort(width);
		bbuf.putShort(height);
		bbuf.putShort(offsetX);
		bbuf.putShort(offsetY);
		
		os.write(buf);
		
		// pixels
		Raster raster = img.getData();
		DataBufferInt dataBuf = (DataBufferInt) raster.getDataBuffer();
		int[] pixels = dataBuf.getData();
		for (int pixel : pixels) {
			int a = (int)((pixel >> 24) & 0xff);
			int r = (int)((pixel >> 16) & 0xff);
			int g = (int)((pixel >> 8) & 0xff);
			int b = (int)(pixel & 0xff);
			
			os.write((byte) b);
			os.write((byte) g);
			os.write((byte) r);
			os.write((byte) a);
		}
	}
	
}
