/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Task;

public class TaskService
extends AbstractBean {
    private final String name;
    private final ExecutorService executorService;
    private final List<Task> tasks;
    private final PropertyChangeListener taskPCL;

    public TaskService(String name, ExecutorService executorService) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
        this.name = name;
        this.executorService = executorService;
        this.tasks = new ArrayList<Task>();
        this.taskPCL = new TaskPCL();
    }

    public TaskService(String name) {
        this(name, new ThreadPoolExecutor(3, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> copyTasksList() {
        List<Task> list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<Task>(this.tasks);
        }
    }

    private void maybeBlockTask(Task task) {
        final Task.InputBlocker inputBlocker = task.getInputBlocker();
        if (inputBlocker == null) {
            return;
        }
        if (inputBlocker.getScope() != Task.BlockingScope.NONE) {
            if (SwingUtilities.isEventDispatchThread()) {
                inputBlocker.block();
            } else {
                Runnable doBlockTask = new Runnable(){

                    @Override
                    public void run() {
                        inputBlocker.block();
                    }
                };
                SwingUtilities.invokeLater(doBlockTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) {
        List<Task> newTaskList;
        List<Task> oldTaskList;
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        if (!task.isPending() || task.getTaskService() != null) {
            throw new IllegalArgumentException("task has already been executed");
        }
        task.setTaskService(this);
        List<Task> list = this.tasks;
        synchronized (list) {
            oldTaskList = this.copyTasksList();
            this.tasks.add(task);
            newTaskList = this.copyTasksList();
            task.addPropertyChangeListener(this.taskPCL);
        }
        this.firePropertyChange("tasks", oldTaskList, newTaskList);
        this.maybeBlockTask(task);
        this.executorService.execute(task);
    }

    public List<Task> getTasks() {
        return this.copyTasksList();
    }

    public final void shutdown() {
        this.executorService.shutdown();
    }

    public final List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    public final boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public final boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    private class TaskPCL
    implements PropertyChangeListener {
        private TaskPCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Task task;
            String propertyName = e.getPropertyName();
            if ("done".equals(propertyName) && (task = (Task)e.getSource()).isDone()) {
                List newTaskList;
                List oldTaskList;
                List list = TaskService.this.tasks;
                synchronized (list) {
                    oldTaskList = TaskService.this.copyTasksList();
                    TaskService.this.tasks.remove(task);
                    task.removePropertyChangeListener(TaskService.this.taskPCL);
                    newTaskList = TaskService.this.copyTasksList();
                }
                TaskService.this.firePropertyChange("tasks", oldTaskList, newTaskList);
                Task.InputBlocker inputBlocker = task.getInputBlocker();
                if (inputBlocker != null) {
                    inputBlocker.unblock();
                }
            }
        }
    }
}

