/*
 * CAN/LIN/UART/PORT Checker for RL78/F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ CANhCo ]
 */

#ifndef CAN_H
#define CAN_H

/*
 * CAN
 * vf[^\
 */
typedef struct _can_stat
{
	u2 rx_cnt[2];
									/* Mt[ */
	u2 ovf_cnt;
									/* Mobt@@I[o[t[t[ */
	u2 tx_cnt[2];
									/* Mt[ */
	u2 abt_cnt;
									/* MA{[gt[ */
	u2 txabt_cnt;
									/* MA{[g(M)t[ */
	u2 ew_cnt;
									/* G[E[jO */
	u2 ep_cnt;
									/* G[EpbVu */
	u2 boe_cnt;
									/* oXItJn */
	u2 bor_cnt;
									/* oXItA */
	u2 ovl_cnt;
									/* I[o[hM */
	u2 bl_cnt;
									/* oXEbNo */
	u2 al_cnt;
									/* A[rg[VEXgo */
	u2 fifo_cnt;
									/* MFIFOI[o[t[o */
	u1 ev_max;
									/* Cxgobt@ő */
	u1 rx_max;
									/* Mobt@ő */
	u1 tx_max;
									/* Mobt@ő */
} can_stat;

/*
 * CAN
 * ^CEX^v\
 */
typedef struct _can_time
{
	u2 us;
									/* ^CX^v(P:1us) */
	u2 us_64k;
									/* ^CX^v(P:64Kus) */
	u2 us_4m;
									/* ^CX^v(P:4096Mus) */
} can_time;

/*
 * CAN
 * CxgER[h`
 */
#define CAN_EVENT_EWF			((u1)(0x01))
									/* G[E[jO */
#define CAN_EVENT_EPF			((u1)(0x02))
									/* G[EpbVu */
#define CAN_EVENT_BOEF			((u1)(0x03))
									/* oXItJn */
#define CAN_EVENT_BORF			((u1)(0x04))
									/* oXItA */
#define CAN_EVENT_OVLF			((u1)(0x05))
									/* I[o[hM */
#define CAN_EVENT_BLF			((u1)(0x06))
									/* `lEoXEbN */
#define CAN_EVENT_ALF			((u1)(0x07))
									/* A[rg[VEXg */
#define CAN_EVENT_RFMLT			((u1)(0x08))
									/* MFIFObZ[WEXg */

/*
 * CAN
 * Cxg\
 */
typedef struct _can_event
{
	u1 event;
									/* CxgER[h */
	u1 sub;
									/* Tu(̃Cxĝݎgp) */
	can_time stamp;
									/* ̃^CEX^v */
} can_event;

/*
 * CAN
 * eXgE[h`
 */
#define CAN_TEST_NORMAL			((u1)(0x00))
									/* WeXgE[h */
#define CAN_TEST_LISTEN_ONLY	((u1)(0x01))
									/* bXEIE[h */
#define CAN_TEST_EXT_LOOP_BACK	((u1)(0x02))
									/* O[vEobNE[h */
#define CAN_TEST_INT_LOOP_BACK	((u1)(0x03))
									/* [vEobNE[h */

/*
 * CAN
 * MXe[^X`
 */
#define CAN_TX_STS_NONE			((u1)(0x00))
									/* Ȃ */
#define CAN_TX_STS_REQ			((u1)(0x01))
									/* Mv */
#define CAN_TX_STS_ABORTED		((u1)(0x02))
									/* MA{[g */
#define CAN_TX_STS_SENT			((u1)(0x04))
									/* M(MA{[gvȂ) */
#define CAN_TX_STS_SENTABORT	((u1)(0x06))
									/* M(MA{[gv) */

/*
 * CAN
 * t[\
 */
typedef struct _can_frame
{
	u2 id_l;
									/* ID(WID̏ꍇb11-b150) */
	u2 id_h;
									/* ID(b31:gIDtOAb30:[gEt[tO */
	u1 sts;
									/* Xe[^X(M݈̂Ӗ) */
	u1 dlc;
									/* DLC(0-8) */
	u1 buf[8];
									/* f[^obt@ */
	can_time stamp;
									/* M܂͎M̃^CEX^v */
} can_frame;

/*
 * CAN
 * RtBM[V
 */
void can_config(void);

/*
 * CAN
 * 
 */
void can_init(void);

/*
 * CAN
 * eXgE[hݒ
 */
void can_test(u1 mode);

/*
 * CAN
 * Jn
 */
void can_start(void);

/*
 * CAN
 * Mt[}
 */
void can_tx_enque(can_frame* ptr);

/*
 * CAN
 * M擾
 */
u1 can_rx_get(void);

/*
 * CAN
 * Mt[擾
 */
void can_rx_deque(can_frame* ptr);

/*
 * CAN
 * Cxg擾
 */
u1 can_event_get(void);

/*
 * CAN
 * Cxg擾
 */
void can_event_deque(can_event* ptr);

/*
 * CAN
 * ACh
 */
void can_idle(void);

/*
 * CAN
 * ^CEX^vXV
 *
 * 1ms^C}荞݂܂͊荞݋֎~ԂŌĂ΂
 */
void can_time_update(void);

/*
 * CAN
 * `lEG[荞
 */
void can_cerr_isr(void);

/*
 * CAN
 * `l0M荞
 */
void can_tx_isr(void);

/*
 * CAN
 * O[oMFIFO荞
 */
void can_rx_isr(void);

/*
 * CAN
 * O[oEG[荞
 */
void can_gerr_isr(void);

#endif /* CAN_H */
