/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.bdd.DoubleCache;

public class Fibonacci {
    private static DoubleCache dc;

    public static double fibonacci(int n) {
        if (n < 0) {
            return -1.0;
        }
        dc = new DoubleCache("fibonacci", n + 3);
        double d = Fibonacci.fibonacci_rec(n);
        dc.showStats();
        dc = null;
        return d;
    }

    private static double fibonacci_rec(int n) {
        if (n < 2) {
            return n;
        }
        if (dc.lookup(n)) {
            return Fibonacci.dc.answer;
        }
        int n2 = Fibonacci.dc.hash_value;
        double d = Fibonacci.fibonacci_rec(n - 1) + Fibonacci.fibonacci_rec(n - 2);
        dc.insert(n2, n, d);
        return d;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: Java jdd.examples.Fibonacci n");
            System.err.println("      n must be a positive integer.");
            System.err.println("      if n is too large, you will see a java.lang.StackOverflowError :(");
        } else {
            int n = Integer.parseInt(stringArray[0]);
            long l = System.currentTimeMillis();
            double d = Fibonacci.fibonacci(n);
            l = System.currentTimeMillis() - l;
            System.out.println("In " + l + " ms:  F(" + n + ") = " + d);
        }
    }
}

