/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import jdd.util.JDDConsole;
import jdd.util.jre.JREInfo;
import jdd.util.math.Digits;

public class Allocator {
    private static long int_s = 0L;
    private static long int_c = 0L;
    private static long short_s = 0L;
    private static long short_c = 0L;
    private static long double_c = 0L;
    private static long char_s = 0L;
    private static long char_c = 0L;
    private static long byte_s = 0L;
    private static long byte_c = 0L;
    private static long double_s = 0L;
    private static long int_t = 0L;
    private static long short_t = 0L;
    private static long char_t = 0L;
    private static long byte_t = 0L;
    private static long double_t = 0L;

    private static void fail(long l, String string, OutOfMemoryError outOfMemoryError) {
        outOfMemoryError.printStackTrace();
        JDDConsole.out.print("FAILED to allocate " + l + " bytes (");
        Digits.printNumber1024(l);
        JDDConsole.out.println(") for an " + string + "[]");
        JDDConsole.out.println("Allocator statistics so far:");
        Allocator.showStats();
        throw outOfMemoryError;
    }

    public static int[] allocateIntArray(int n) {
        if (int_s < (long)n) {
            int_s = n;
        }
        ++int_c;
        int_t += (long)n;
        try {
            return new int[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Allocator.fail((long)n * 4L, "int", outOfMemoryError);
            return null;
        }
    }

    public static double[] allocateDoubleArray(int n) {
        if (double_s < (long)n) {
            double_s = n;
        }
        ++double_c;
        double_t += (long)n;
        try {
            return new double[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Allocator.fail((long)n * 8L, "double", outOfMemoryError);
            return null;
        }
    }

    public static short[] allocateShortArray(int n) {
        if (short_s < (long)n) {
            short_s = n;
        }
        ++short_c;
        short_t += (long)n;
        try {
            return new short[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Allocator.fail((long)n * 2L, "short", outOfMemoryError);
            return null;
        }
    }

    public static char[] allocateCharArray(int n) {
        if (char_s < (long)n) {
            char_s = n;
        }
        ++char_c;
        char_t += (long)n;
        try {
            return new char[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Allocator.fail((long)n * 2L, "char", outOfMemoryError);
            return null;
        }
    }

    public static byte[] allocateByteArray(int n) {
        if (byte_s < (long)n) {
            byte_s = n;
        }
        ++byte_c;
        byte_t += (long)n;
        try {
            return new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Allocator.fail(n, "byte", outOfMemoryError);
            return null;
        }
    }

    public static boolean[] allocateBooleanArray(int n) {
        return new boolean[n];
    }

    public static void showStats() {
        JDDConsole.out.print("Allocator , total mem: " + (int_t * 4L + short_t * 4L + char_t * 2L + byte_t));
        JDDConsole.out.println(", stats (type,count,max,total):");
        if (int_c > 0L) {
            JDDConsole.out.print("(int," + int_c + "," + int_s + "," + int_t + ")");
        }
        if (short_c > 0L) {
            JDDConsole.out.print(" (short," + short_c + "," + short_s + "," + short_t + ")");
        }
        if (char_c > 0L) {
            JDDConsole.out.print(" (char," + char_c + "," + char_s + "," + char_t + ")");
        }
        if (byte_c > 0L) {
            JDDConsole.out.print(" (byte," + byte_c + "," + byte_s + "," + byte_t + ")");
        }
        if (double_c > 0L) {
            JDDConsole.out.print(" (double," + double_c + "," + double_s + "," + double_t + ")");
        }
        JDDConsole.out.println();
        JDDConsole.out.print("Total / Max / Used / Free memory: ");
        Digits.printNumber1024(JREInfo.totalMemory());
        JDDConsole.out.print("/ ");
        Digits.printNumber1024(JREInfo.maxMemory());
        JDDConsole.out.print("/ ");
        Digits.printNumber1024(JREInfo.usedMemory());
        JDDConsole.out.print("/ ");
        Digits.printNumber1024(JREInfo.freeMemory());
        JDDConsole.out.println();
    }
}

