package v1;

import jdd.bdd.BDD;

import java.util.ArrayList;
import java.util.List;

class ConstraintHandler {
	List<VariableAndBDD> parameters = null;
	BDD bdd;
	int bddConstraint;
	int numOfBDDvariables;
	
	ConstraintHandler(PList parameterList, List<Node> constraintList) {
		//TODO BDDݒ -> 1000, ... 萔
		bdd = new BDD(1000,1000);
		
		//parameter̃Xg
		parameters = setBDDforParameter(parameterList);
		
		//contrainListAm[hĂ
		bddConstraint = setBddConstraint(constraintList);
		
		// boolean ϐ̑vZ
		// numOfBooleanVariable = computeNumOfBooleanVariables
	}

	void printConstraintBDD() {
		bdd.printSet(bddConstraint);
	}
	
	// ep[^booleanϐ蓖āDvZ
	private List<VariableAndBDD> setBDDforParameter(PList parameterList) {
		List<VariableAndBDD> res = new ArrayList<VariableAndBDD>();
		this.numOfBDDvariables = 0;
		
		for (Parameter p: parameterList) {
			// BDDϐ̐ݒ
			int num_vars = 1;
			for (int levels = 2; ;  levels *= 2) {
				if (p.value_name.size()  < levels) 
					break;
				num_vars++;
			}	
			// BDDϐ̑vZ
			numOfBDDvariables += num_vars;
			
			// boolean variables
			// ꂽ getVar(v): 0, 1, 2, ..
			int[] var = new int[num_vars];
			for (int i = num_vars - 1; i >= 0; i--) {
				var[i] = bdd.createVar();
			}
			
			// BDD̐ݒ
			// constraint for invalid values
			// domain-1ȉ̐̂ݗL
			// bool variables ̐domain-1킹邾͂
			// 
			// domain-12i\ł́Cŏʂ̕ϐɂrbg͏1
			// Ƃ͌Ȃ
			int f = bdd.getZero();
			// domain-1菬
			for (int i = var.length - 1; i >= 0; i--) {
				if ((p.value_name.size() - 1 & (0x01 << i)) > 0) {
					int g = bdd.getOne(); 
					for (int j = var.length - 1; j > i; j--) {
						if ((p.value_name.size() - 1 & (0x01 << j)) > 0) {
							g = bdd.and(g, var[j]);
						} else {
							g = bdd.and(g, bdd.not(var[j]));
						}
					}
					f = bdd.or(f, bdd.and(g, bdd.not(var[i])));
				}
			}
			bdd.ref(f);
			
			// domain - 1g
			int g = bdd.getOne(); 
			for (int i = var.length - 1; i >= 0; i--) {
				if ((p.value_name.size() - 1 & (0x01 << i)) > 0) {
					g = bdd.and(g, var[i]);
				} else {
					g = bdd.and(g, bdd.not(var[i]));
				}
			}
			bdd.ref(g);
			
			int d = bdd.or(f, g);
			bdd.ref(d);
			bdd.deref(f);
			bdd.deref(g);
			
			// var, d  listɒǉ
			res.add(new VariableAndBDD(var, d));
		}
		return res;
	}

	private int setBddConstraint(List<Node> constraintList) {
		// TODO Auto-generated method stub
		int f = bdd.getOne();
		
		// p[^łȂ̈falseɂ
		for (VariableAndBDD vb : parameters) {
			f = bdd.and(f, vb.constraint);
		}
		
		// 񎮂̘_ςƂ
		for (Node n: constraintList) {
			int g = n.evaluate(bdd, parameters);
			f = bdd.and(f, g);
			bdd.ref(f);
			bdd.deref(g);
		}
//		bdd.ref(f);
		// 
		bdd.printSet(f);
		
		// *t
		f = extendBddConstraint(f);

		// 
		bdd.printSet(f);

		return f;
	}
	
	private int extendBddConstraint(int constraint) {
		int f = constraint;
		for (VariableAndBDD p : parameters) {
			int cube = p.var[0];
			for (int i = 1; i < p.var.length; i++) {
				cube = bdd.and(cube, p.var[i]);
			}
			bdd.ref(cube);
			int tmp0 = bdd.ref(bdd.exists(f, cube));
			bdd.ref(tmp0);
			int tmp = bdd.ref(bdd.and(tmp0, cube));
			bdd.ref(tmp);
			int newf =
				bdd.ref(bdd.or(f, tmp));
			bdd.ref(newf);
			
			bdd.deref(cube);
			bdd.deref(tmp0);
			bdd.deref(tmp);
			bdd.deref(f);
			f = newf;
		}
		return f;
	}
	
	//TODO eXgP[X𖞂
	boolean isPossible (Testcase test) {
		int node = bddConstraint;
		boolean[] bv = binarize(test);
		
		while (true) {
			// P^CPU
			if (node == 0) return false;
			else if (node == 1) return true;

			// pos0, 1̓m[hȂ
			if (bv[bdd.getVar(node)] == true) 
				node = bdd.getHigh(node);
			else
				node = bdd.getLow(node);
		}
	}
	
	private boolean[] binarize(Testcase test) {
		// assert(testcase̒ = parameter̐) 
		boolean[] res = new boolean[numOfBDDvariables];
		int pos = 0; 
		// eq̒l2lŕ\
		for (int i = 0; i < test.value.length; i++) {
			VariableAndBDD p = parameters.get(i);
			int lv = test.get(i);
			if (lv < 0) { // wild card
				for (int j = 0; j < p.var.length; j++)
					res[pos + j] = true;
			} else {
				int j0 = 0;
				for (int j = p.var.length -1 ; j >= 0; j--) {
					if ((lv & (0x01 << j)) > 0) 
						res[pos + j0]= true;
					else res[pos + j0] = false;
					j0++;
				}
			}
			pos += p.var.length;
		}
		/*
		this.print();
		for (int k = 0; k < res.length; k++) 
			System.out.print(res[k] ? 1 : 0);
		System.out.println("<-");
			*/
		return res;
	}
}

class VariableAndBDD {
	int[] var; // bdd nodes
	// TODO O constraint -> 悢̂
	int constraint; // bdd for invalid values

	VariableAndBDD(int[] var, int constraint) {
		this.var = var;
		this.constraint = constraint;
	}
}