/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.petrinets;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.xml.parsers.SAXParser;
import jdd.des.petrinets.Petrinet;
import jdd.des.petrinets.PetrinetTransform;
import jdd.des.petrinets.PetrinetXMLHandler;
import jdd.des.petrinets.Place;
import jdd.des.petrinets.PlaceEnumeration;
import jdd.des.petrinets.Transition;
import jdd.des.petrinets.interactive.IPetrinet;
import jdd.util.JDDConsole;
import jdd.util.NotCloseableInputStream;
import jdd.util.Test;
import jdd.util.XMLHelper;
import org.xml.sax.helpers.DefaultHandler;

public class PetrinetIO {
    public static void show(Petrinet petrinet) {
        int[] nArray = petrinet.getM();
        int n = petrinet.numberOfPlaces();
        JDDConsole.out.print("M_i = [");
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                JDDConsole.out.print(", ");
            }
            JDDConsole.out.print("" + nArray[i]);
        }
        JDDConsole.out.println("]");
        JDDConsole.out.println("A-");
        petrinet.getAMinus().show();
        JDDConsole.out.println("A+");
        petrinet.getAPlus().show();
    }

    public static void saveXML(Petrinet petrinet, String string) {
        try {
            Place place;
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            printStream.println("\t<Petrinet>");
            printStream.println("\t\t<Places>");
            int n = petrinet.numberOfPlaces();
            for (int i = 0; i < n; ++i) {
                place = petrinet.getPlaceByIndex(i);
                printStream.print("\t\t\t<Place label=\"" + place.getName() + "\"");
                if (place.getTokens() > 0) {
                    printStream.print(" token=\"" + place.getTokens() + "\"");
                }
                printStream.print("/>");
            }
            printStream.println("\t\t</Places>");
            printStream.println("\t\t<Transitions>");
            n = petrinet.numberOfTransitions();
            PlaceEnumeration placeEnumeration = new PlaceEnumeration(petrinet);
            for (int i = 0; i < n; ++i) {
                Transition transition = petrinet.getTransitionByIndex(i);
                printStream.print("\t\t\t<Transition label=\"" + transition.getName() + "\"");
                if (!transition.isControllable()) {
                    printStream.print(" controllable=\"false\"");
                }
                if (!transition.isObservable()) {
                    printStream.print(" observable=\"false\"");
                }
                printStream.println(" >");
                petrinet.incomingPlaces(placeEnumeration, transition);
                while ((place = placeEnumeration.nextPlace()) != null) {
                    printStream.println("\t\t\t<Input place=\"" + place.getName() + "\"/>");
                }
                petrinet.outgoingPlaces(placeEnumeration, transition);
                while ((place = placeEnumeration.nextPlace()) != null) {
                    printStream.println("\t\t\t<Output place=\"" + place.getName() + "\"/>");
                }
                printStream.println("\t\t\t</Transition>");
            }
            printStream.println("\t\t</Transitions>");
            printStream.println("\t</Petrinet>");
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to save petrinet to " + string + ":" + iOException);
        }
    }

    public static Petrinet loadXML(String string) {
        IPetrinet iPetrinet = PetrinetIO.loadXMLInteractive(string);
        if (iPetrinet != null) {
            return PetrinetTransform.convert(iPetrinet);
        }
        return null;
    }

    public static IPetrinet loadXMLInteractive(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            SAXParser sAXParser = XMLHelper.getParser();
            PetrinetXMLHandler petrinetXMLHandler = new PetrinetXMLHandler();
            sAXParser.parse((InputStream)new NotCloseableInputStream(fileInputStream), (DefaultHandler)petrinetXMLHandler);
            ((InputStream)fileInputStream).close();
            return petrinetXMLHandler.petrinet;
        }
        catch (Exception exception) {
            JDDConsole.out.println("Unable to load IPetrinet from " + string + ":" + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public static void internal_test() {
        Test.start("PetrinetIO");
        Petrinet petrinet = PetrinetIO.loadXML("data/agv.xml");
        Test.checkEquality(petrinet.numberOfPlaces(), 64, "# of places loaded");
        Test.checkEquality(petrinet.numberOfTransitions(), 53, "# of transition loaded");
        Test.end();
    }
}

