/*
 * Decompiled with CFR 0.152.
 */
package jdd.zdd;

import java.util.Collection;
import java.util.StringTokenizer;
import jdd.bdd.NodeTable;
import jdd.bdd.OptimizedCache;
import jdd.bdd.debug.BDDDebugFrame;
import jdd.bdd.debug.BDDDebuger;
import jdd.util.Array;
import jdd.util.Configuration;
import jdd.util.NodeName;
import jdd.util.Options;
import jdd.util.Test;
import jdd.zdd.ZDDNames;
import jdd.zdd.ZDDPrinter;

public class ZDD
extends NodeTable {
    private static final int CACHE_SUBSET0 = 0;
    private static final int CACHE_SUBSET1 = 1;
    private static final int CACHE_CHANGE = 2;
    private static final int CACHE_UNION = 3;
    private static final int CACHE_INTERSECT = 4;
    private static final int CACHE_DIFF = 5;
    protected int num_vars;
    private int node_count_int;
    private OptimizedCache unary_cache;
    private OptimizedCache binary_cache;
    protected NodeName nodeNames = new ZDDNames();

    public ZDD(int n) {
        this(n, 1000);
    }

    public ZDD(int n, int n2) {
        super(n);
        this.unary_cache = new OptimizedCache("unary", n2 / Configuration.zddUnaryCacheDiv, 3, 1);
        this.binary_cache = new OptimizedCache("binary", n2 / Configuration.zddBinaryCacheDiv, 3, 2);
        if (Options.profile_cache) {
            new BDDDebugFrame(this);
        }
        this.enableStackMarking();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.binary_cache = null;
        this.unary_cache = null;
    }

    @Override
    public Collection addDebugger(BDDDebuger bDDDebuger) {
        Collection collection = super.addDebugger(bDDDebuger);
        collection.add(this.unary_cache);
        collection.add(this.binary_cache);
        return collection;
    }

    @Override
    protected void post_removal_callbak() {
        this.binary_cache.free_or_grow(this);
        this.unary_cache.free_or_grow(this);
    }

    protected final int mk(int n, int n2, int n3) {
        if (n3 == 0) {
            return n2;
        }
        return this.add(n, n2, n3);
    }

    public int createVar() {
        int n = this.num_vars++;
        int n2 = 5 * this.num_vars + 3;
        if (this.work_stack.length < n2) {
            this.work_stack = Array.resize(this.work_stack, this.work_stack_tos, n2);
        }
        this.tree_depth_changed(this.num_vars);
        return n;
    }

    public final int empty() {
        return 0;
    }

    public final int base() {
        return 1;
    }

    public final int single(int n) {
        return this.mk(n, 0, 1);
    }

    public final int universe() {
        int n = 1;
        for (int i = 0; i < this.num_vars; ++i) {
            this.work_stack[this.work_stack_tos++] = n;
            n = this.mk(i, n, n);
            --this.work_stack_tos;
        }
        return n;
    }

    public final int cube(int n) {
        return this.mk(n, 0, 1);
    }

    public final int cube(boolean[] blArray) {
        int n = 1;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            this.work_stack[this.work_stack_tos++] = n;
            n = this.mk(i, 0, n);
            --this.work_stack_tos;
        }
        return n;
    }

    public final int cube(String string) {
        int n = string.length();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(n - i - 1) != '1') continue;
            this.work_stack[this.work_stack_tos++] = n2;
            n2 = this.mk(i, 0, n2);
            --this.work_stack_tos;
        }
        return n2;
    }

    public int cubes_union(String string) {
        return this.do_cubes_op(string, true);
    }

    public int cubes_intersect(String string) {
        return this.do_cubes_op(string, false);
    }

    private int do_cubes_op(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n,;");
        int n = -1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = this.cube(string2);
            if (n == -1) {
                n = n2;
                continue;
            }
            this.ref(n);
            this.ref(n2);
            int n3 = bl ? this.union(n, n2) : this.intersect(n, n2);
            this.deref(n);
            this.deref(n2);
            n = n3;
        }
        return n;
    }

    public int subsets(boolean[] blArray) {
        int n = 1;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            this.work_stack[this.work_stack_tos++] = n;
            n = this.mk(i, n, n);
            --this.work_stack_tos;
        }
        return n;
    }

    public final int subset1(int n, int n2) {
        if (n2 < 0 || n2 >= this.num_vars) {
            return -1;
        }
        if (this.getVar(n) < n2) {
            return 0;
        }
        if (this.getVar(n) == n2) {
            return this.getHigh(n);
        }
        if (this.unary_cache.lookup(n, n2, 1)) {
            return this.unary_cache.answer;
        }
        int n3 = this.unary_cache.hash_value;
        int n4 = this.subset1(this.getLow(n), n2);
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.subset1(this.getHigh(n), n2);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        n5 = this.mk(this.getVar(n), n5, n7);
        this.work_stack_tos -= 2;
        this.unary_cache.insert(n3, n, n2, 1, n5);
        return n5;
    }

    public final int subset0(int n, int n2) {
        if (n2 < 0 || n2 >= this.num_vars) {
            return -1;
        }
        if (this.getVar(n) < n2) {
            return n;
        }
        if (this.getVar(n) == n2) {
            return this.getLow(n);
        }
        if (this.unary_cache.lookup(n, n2, 0)) {
            return this.unary_cache.answer;
        }
        int n3 = this.unary_cache.hash_value;
        int n4 = this.subset0(this.getLow(n), n2);
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.subset0(this.getHigh(n), n2);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        n5 = this.mk(this.getVar(n), n5, n7);
        this.work_stack_tos -= 2;
        this.unary_cache.insert(n3, n, n2, 0, n5);
        return n5;
    }

    public final int change(int n, int n2) {
        if (n2 < 0 || n2 >= this.num_vars) {
            return -1;
        }
        if (this.getVar(n) < n2) {
            return this.mk(n2, 0, n);
        }
        if (this.getVar(n) == n2) {
            return this.mk(n2, this.getHigh(n), this.getLow(n));
        }
        if (this.unary_cache.lookup(n, n2, 2)) {
            return this.unary_cache.answer;
        }
        int n3 = this.unary_cache.hash_value;
        int n4 = this.change(this.getLow(n), n2);
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.change(this.getHigh(n), n2);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        n5 = this.mk(this.getVar(n), n5, n7);
        this.work_stack_tos -= 2;
        this.unary_cache.insert(n3, n, n2, 2, n5);
        return n5;
    }

    public final int union(int n, int n2) {
        int n3;
        if (this.getVar(n) > this.getVar(n2)) {
            return this.union(n2, n);
        }
        if (n == 0) {
            return n2;
        }
        if (n2 == 0 || n2 == n) {
            return n;
        }
        if (this.binary_cache.lookup(n, n2, 3)) {
            return this.binary_cache.answer;
        }
        int n4 = this.binary_cache.hash_value;
        if (this.getVar(n) < this.getVar(n2)) {
            int n5 = this.union(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n5;
            n3 = n5;
            n3 = this.mk(this.getVar(n2), n3, this.getHigh(n2));
            --this.work_stack_tos;
        } else {
            int n6 = this.union(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n6;
            n3 = n6;
            int n7 = this.union(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            n3 = this.mk(this.getVar(n), n3, n8);
            this.work_stack_tos -= 2;
        }
        this.binary_cache.insert(n4, n, n2, 3, n3);
        return n3;
    }

    public final int intersect(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n2 == n) {
            return n;
        }
        if (n == 1) {
            return this.follow_low(n2);
        }
        if (n2 == 1) {
            return this.follow_low(n);
        }
        if (this.binary_cache.lookup(n, n2, 4)) {
            return this.binary_cache.answer;
        }
        int n3 = this.binary_cache.hash_value;
        int n4 = 0;
        if (this.getVar(n) > this.getVar(n2)) {
            n4 = this.intersect(this.getLow(n), n2);
        } else if (this.getVar(n) < this.getVar(n2)) {
            n4 = this.intersect(n, this.getLow(n2));
        } else {
            int n5 = this.intersect(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n5;
            n4 = n5;
            int n6 = this.intersect(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n6;
            int n7 = n6;
            n4 = this.mk(this.getVar(n), n4, n7);
            this.work_stack_tos -= 2;
        }
        this.binary_cache.insert(n3, n, n2, 4, n4);
        return n4;
    }

    public final int diff(int n, int n2) {
        if (n == 0 || n == n2) {
            return 0;
        }
        if (n2 == 0) {
            return n;
        }
        if (this.binary_cache.lookup(n, n2, 5)) {
            return this.binary_cache.answer;
        }
        int n3 = this.binary_cache.hash_value;
        int n4 = 0;
        if (this.getVar(n) < this.getVar(n2)) {
            n4 = this.diff(n, this.getLow(n2));
        } else if (this.getVar(n) > this.getVar(n2)) {
            int n5 = this.diff(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n5;
            n4 = n5;
            n4 = this.mk(this.getVar(n), n4, this.getHigh(n));
            --this.work_stack_tos;
        } else {
            int n6 = this.diff(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n6;
            n4 = n6;
            int n7 = this.diff(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            n4 = this.mk(this.getVar(n), n4, n8);
            this.work_stack_tos -= 2;
        }
        this.binary_cache.insert(n3, n, n2, 5, n4);
        return n4;
    }

    public final int follow_low(int n) {
        while (n >= 2) {
            n = this.getLow(n);
        }
        return n;
    }

    public final int follow_high(int n) {
        while (n >= 2) {
            n = this.getHigh(n);
        }
        return n;
    }

    public final boolean emptyIn(int n) {
        return this.follow_low(n) == 1;
    }

    private final int insert_base(int n) {
        if (n < 2) {
            return 1;
        }
        int n2 = this.insert_base(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        n3 = this.getLow(n) == n3 ? n : this.mk(this.getVar(n), n3, this.getHigh(n));
        --this.work_stack_tos;
        return n3;
    }

    public boolean[] satOne(int n, boolean[] blArray) {
        if (n == 0) {
            return null;
        }
        if (blArray == null) {
            blArray = new boolean[this.num_vars];
        }
        Array.set(blArray, false);
        if (n != 1) {
            this.satOne_rec(n, blArray);
        }
        return blArray;
    }

    private void satOne_rec(int n, boolean[] blArray) {
        if (n < 2) {
            return;
        }
        int n2 = this.getLow(n);
        if (n2 == 0) {
            blArray[this.getVar((int)n)] = true;
            n2 = this.getHigh(n);
        }
        this.satOne_rec(n2, blArray);
    }

    public final int count(int n) {
        if (n < 2) {
            return n;
        }
        return this.count(this.getLow(n)) + this.count(this.getHigh(n));
    }

    public int nodeCount(int n) {
        this.node_count_int = 0;
        this.nodeCount_mark(n);
        this.unmark_tree(n);
        return this.node_count_int;
    }

    private final void nodeCount_mark(int n) {
        if (n < 2) {
            return;
        }
        if (this.isNodeMarked(n)) {
            return;
        }
        this.mark_node(n);
        ++this.node_count_int;
        this.nodeCount_mark(this.getLow(n));
        this.nodeCount_mark(this.getHigh(n));
    }

    public int unionTo(int n, int n2) {
        int n3 = this.ref(this.union(n, n2));
        this.deref(n);
        return n3;
    }

    public int diffTo(int n, int n2) {
        int n3 = this.ref(this.diff(n, n2));
        this.deref(n);
        return n3;
    }

    @Override
    public void showStats() {
        super.showStats();
        this.unary_cache.showStats();
        this.binary_cache.showStats();
    }

    @Override
    public long getMemoryUsage() {
        long l = super.getMemoryUsage();
        if (this.unary_cache != null) {
            l += this.unary_cache.getMemoryUsage();
        }
        if (this.binary_cache != null) {
            l += this.binary_cache.getMemoryUsage();
        }
        return l;
    }

    public void setNodeNames(NodeName nodeName) {
        this.nodeNames = nodeName;
    }

    public void print(int n) {
        ZDDPrinter.print(n, this, this.nodeNames);
    }

    public void printDot(String string, int n) {
        ZDDPrinter.printDot(string, n, this, this.nodeNames);
    }

    public void printSet(int n) {
        ZDDPrinter.printSet(n, this, this.nodeNames);
    }

    public void printCubes(int n) {
        ZDDPrinter.printSet(n, this, null);
    }

    public static void internal_test() {
        Test.start("ZDD");
        ZDD zDD = new ZDD(100);
        Test.checkEquality(zDD.getVar(0), -1, "false.top");
        Test.checkEquality(zDD.getVar(1), -1, "true.top");
        int n = zDD.createVar();
        int n2 = zDD.createVar();
        int n3 = zDD.empty();
        int n4 = zDD.base();
        int n5 = zDD.change(n4, n);
        int n6 = zDD.change(n4, n2);
        int n7 = zDD.union(n5, n6);
        int n8 = zDD.union(n4, n7);
        int n9 = zDD.diff(n8, n5);
        Test.checkEquality(n3, 0, "emptyset = 0");
        Test.checkEquality(n4, 1, "base = 1");
        Test.checkEquality(n5, zDD.mk(n, 0, 1), "C");
        Test.checkEquality(n6, zDD.mk(n2, 0, 1), "D");
        Test.checkEquality(zDD.getLow(n7), n5, "E");
        Test.checkEquality(zDD.getHigh(n7), 1, "E");
        int n10 = zDD.mk(n, 1, 1);
        Test.checkEquality(zDD.getLow(n8), n10, "F");
        Test.checkEquality(zDD.getHigh(n8), 1, "F");
        Test.checkEquality(n9, zDD.mk(n2, 1, 1), "G");
        Test.checkEquality(zDD.intersect(n3, n4), n3, "intersect (1)");
        Test.checkEquality(zDD.intersect(n3, n3), n3, "intersect (2)");
        Test.checkEquality(zDD.intersect(n4, n4), n4, "intersect (3)");
        Test.checkEquality(zDD.intersect(n5, n7), n5, "intersect (4)");
        Test.checkEquality(zDD.intersect(n7, n8), n7, "intersect (5)");
        Test.checkEquality(zDD.intersect(n7, n9), n6, "intersect (6)");
        Test.checkEquality(zDD.union(n3, n3), n3, "union (1)");
        Test.checkEquality(zDD.union(n4, n4), n4, "union (2)");
        Test.checkEquality(zDD.union(n3, n4), n4, "union (3)");
        Test.checkEquality(zDD.union(n9, n7), n8, "union (4)");
        Test.checkEquality(zDD.diff(n3, n3), n3, "diff (1)");
        Test.checkEquality(zDD.diff(n4, n4), n3, "diff (2)");
        Test.checkEquality(zDD.diff(n6, n5), n6, "diff (3)");
        Test.checkEquality(zDD.diff(n5, n6), n5, "diff (4)");
        Test.checkEquality(zDD.diff(n7, n5), n6, "diff (5)");
        Test.checkEquality(zDD.diff(n7, n6), n5, "diff (6)");
        Test.checkEquality(zDD.diff(n9, n4), n6, "diff (7)");
        Test.checkEquality(zDD.diff(n9, n6), n4, "diff (8)");
        Test.checkEquality(zDD.diff(n8, n9), n5, "diff (9)");
        Test.checkEquality(zDD.diff(n8, n7), n4, "diff (10)");
        Test.checkEquality(zDD.subset0(n4, n), n4, "subset0 (1)");
        Test.checkEquality(zDD.subset0(n4, n2), n4, "subset0 (2)");
        Test.checkEquality(zDD.subset0(n6, n2), n3, "subset0 (3)");
        Test.checkEquality(zDD.subset0(n7, n2), n5, "subset0 (4)");
        Test.checkEquality(zDD.subset1(n4, n), 0, "subset1 (1)");
        Test.checkEquality(zDD.subset1(n4, n2), 0, "subset1 (2)");
        Test.checkEquality(zDD.subset1(n6, n2), n4, "subset1 (3)");
        Test.checkEquality(zDD.subset1(n9, n2), n4, "subset1 (4)");
        Test.checkEquality(zDD.subset1(n9, n), n3, "subset1 (5)");
        Test.checkEquality(zDD.subset1(n7, n2), n4, "subset0 (6)");
        int n11 = zDD.createVar();
        int n12 = zDD.createVar();
        n10 = zDD.union(1, zDD.change(1, n));
        int n13 = zDD.change(n10, n2);
        n10 = zDD.union(n10, n13);
        int n14 = zDD.union(n10, zDD.change(1, n11));
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[0] = false;
        n10 = zDD.subsets(blArray);
        blArray[0] = true;
        blArray[1] = false;
        n13 = zDD.subsets(blArray);
        n10 = zDD.intersect(n10, n13);
        blArray[1] = true;
        blArray[0] = true;
        blArray[3] = true;
        blArray[2] = false;
        n13 = zDD.subsets(blArray);
        n10 = zDD.union(n13, n10);
        blArray[0] = true;
        blArray[3] = true;
        blArray[2] = true;
        blArray[3] = false;
        n13 = zDD.subsets(blArray);
        int n15 = zDD.intersect(n13, n10);
        Test.checkEquality(n15, n14, "Fig.13 and Fig.14 yield equal result");
        n10 = zDD.cubes_union("100 011 010");
        n13 = zDD.union(zDD.cube("11"), 1);
        int n16 = zDD.intersect(n10, n13);
        int n17 = zDD.cube("11");
        Test.checkEquality(n16, n17, "intersect test");
        Test.checkEquality(zDD.work_stack_tos, 0, "TOS restored after intersect");
        n16 = zDD.union(n10, n13);
        n17 = zDD.union(n10, 1);
        Test.checkEquality(n16, n17, "union test");
        Test.checkEquality(zDD.work_stack_tos, 0, "TOS restored after union");
        n16 = zDD.diff(n10, n13);
        n17 = zDD.union(zDD.cube("10"), zDD.cube("100"));
        Test.checkEquality(n16, n17, "diff test");
        Test.checkEquality(zDD.work_stack_tos, 0, "TOS restored after diff");
        Test.end();
    }
}

