/*
 * Decompiled with CFR 0.152.
 */
package jdd.bed;

import jdd.bdd.NodeTable;
import jdd.bed.BEDNames;
import jdd.bed.BEDPrinter;
import jdd.util.Array;
import jdd.util.NodeName;
import jdd.util.Test;

public class BED
extends NodeTable {
    private static final int TYPE_MASK = 7;
    private static final int VAR_SHIFT = 4;
    public static final int TYPE_BDD = 0;
    public static final int TYPE_NOT = 1;
    public static final int TYPE_AND = 2;
    public static final int TYPE_OR = 3;
    public static final int TYPE_XOR = 4;
    public static final int TYPE_IMPLY = 5;
    private static final String[] OP_NAMES = new String[]{"BDD", "~", "and", "or", "xor", "->"};
    private int num_vars = 0;
    private NodeName nodeNames = new BEDNames();

    static final String GET_OPERATION_NAME(int n) {
        return OP_NAMES[n & 7];
    }

    static final int GET_OPERATION(int n) {
        return n & 7;
    }

    static final int GET_VARIABLE(int n) {
        return n >>> 4;
    }

    static final boolean IS_BDD(int n) {
        return BED.GET_OPERATION(n) == 0;
    }

    static final boolean IS_CONSTANT(int n) {
        return n < 2;
    }

    static final boolean IS_OPERATION(int n) {
        int n2 = BED.GET_OPERATION(n);
        return n2 > 0;
    }

    static final int MAKE_VAR(int n) {
        return n << 4 | 0;
    }

    public final boolean isBDD(int n) {
        return BED.IS_BDD(this.getVar(n));
    }

    public final int getOperation(int n) {
        return BED.GET_OPERATION(this.getVar(n));
    }

    public final int getVariable(int n) {
        return BED.GET_VARIABLE(this.getVar(n));
    }

    public BED(int n, int n2) {
        super(n);
    }

    public int createVar() {
        int n = BED.MAKE_VAR(this.num_vars);
        int n2 = this.mk(n, 0, 1);
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        int n4 = this.mk(n, 1, 0);
        --this.work_stack_tos;
        ++this.num_vars;
        this.saturate(n3);
        this.saturate(n4);
        int n5 = 5 * this.num_vars + 1;
        if (this.work_stack.length < n5) {
            this.work_stack = Array.resize(this.work_stack, this.work_stack_tos, n5);
        }
        this.tree_depth_changed(this.num_vars * 4);
        return n3;
    }

    public int mk(int n, int n2, int n3) {
        if (BED.IS_BDD(n)) {
            if (n2 == n3) {
                return n2;
            }
            return this.add(n, n2, n3);
        }
        return this.rewrite_and_insert(n, n2, n3);
    }

    private final int rewrite_and_insert(int n, int n2, int n3) {
        if (n == 1) {
            if (n2 < 2) {
                return n2 ^ 1;
            }
            if (this.getOperation(n2) == 1) {
                return this.getLow(n2);
            }
            int n4 = this.getVar(n2);
            if (BED.IS_BDD(n4)) {
                int n5 = this.getLow(n2);
                int n6 = this.getHigh(n2);
                if (n5 < 2 && n6 < 2) {
                    return this.mk(n4, n6, n5);
                }
            }
        } else if (n2 < 2 || n3 < 2 || n2 == n3) {
            switch (n) {
                case 2: {
                    if (n2 == 0 || n3 == 0) {
                        return 0;
                    }
                    if (n2 == 1) {
                        return n3;
                    }
                    if (n3 != 1 && n2 != n3) break;
                    return n2;
                }
                case 3: {
                    if (n2 == 1 || n3 == 1) {
                        return 1;
                    }
                    if (n2 == 0) {
                        return n3;
                    }
                    if (n3 != 0 && n2 != n3) break;
                    return n2;
                }
                case 4: {
                    if (n2 == 1) {
                        return this.not(n3);
                    }
                    if (n2 == 0) {
                        return n3;
                    }
                    if (n3 == 1) {
                        return this.not(n2);
                    }
                    if (n3 == 0) {
                        return n2;
                    }
                    if (n2 != n3) break;
                    return 0;
                }
                case 5: {
                    if (n2 == 0 || n2 == n3) {
                        return 1;
                    }
                    if (n2 == 1) {
                        return n3;
                    }
                    if (n3 == 1) {
                        return 1;
                    }
                    if (n3 != 0) break;
                    return this.not(n2);
                }
            }
        }
        return this.add(n, n2, n3);
    }

    public static final long MIX(int n, int n2) {
        return (long)n << 32 | (long)n2;
    }

    public static final int SPLIT1(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static final int SPLIT2(long l) {
        return (int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public int up_one(int n, int n2) {
        int n3 = this.getVariable(n);
        long l = this.up_one_rec(n3, n2);
        int n4 = BED.SPLIT1(l);
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = BED.SPLIT2(l);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        n5 = this.mk(BED.MAKE_VAR(n3), n5, n7);
        this.work_stack_tos -= 2;
        return n5;
    }

    private final long up_one_rec(int n, int n2) {
        int n3;
        if (n2 < 2) {
            return BED.MIX(n2, n2);
        }
        int n4 = this.getVar(n2);
        int n5 = BED.GET_OPERATION(n4);
        if (n5 == 0 && (n3 = BED.GET_VARIABLE(n4)) == n) {
            return BED.MIX(this.getLow(n2), this.getHigh(n2));
        }
        long l = this.up_one_rec(n, this.getLow(n2));
        int n6 = BED.SPLIT1(l);
        this.work_stack[this.work_stack_tos++] = n6;
        int n7 = n6;
        int n8 = BED.SPLIT2(l);
        this.work_stack[this.work_stack_tos++] = n8;
        int n9 = n8;
        l = this.up_one_rec(n, this.getHigh(n2));
        int n10 = BED.SPLIT1(l);
        this.work_stack[this.work_stack_tos++] = n10;
        int n11 = n10;
        int n12 = BED.SPLIT2(l);
        this.work_stack[this.work_stack_tos++] = n12;
        int n13 = n12;
        int n14 = this.mk(n4, n7, n11);
        this.work_stack[this.work_stack_tos++] = n14;
        int n15 = n14;
        int n16 = this.mk(n4, n9, n13);
        this.work_stack_tos -= 5;
        return BED.MIX(n15, n16);
    }

    public int up_all(int n) {
        if (n < 2) {
            return n;
        }
        int n2 = this.up_all(this.getLow(n));
        this.work_stack[this.work_stack_tos++] = n2;
        int n3 = n2;
        int n4 = this.up_all(this.getHigh(n));
        this.work_stack[this.work_stack_tos++] = n4;
        int n5 = n4;
        int n6 = this.getVar(n);
        if (n3 < 2 && n5 < 2 || BED.IS_BDD(n6)) {
            n3 = this.mk(n6, n3, n5);
            this.work_stack_tos -= 2;
        } else {
            int n7;
            int n8 = this.getVariable(n3);
            if (n8 == (n7 = this.getVariable(n5))) {
                int n9 = this.mk(n6, this.getLow(n3), this.getLow(n5));
                this.work_stack[this.work_stack_tos++] = n9;
                int n10 = n9;
                this.work_stack[this.work_stack_tos - 1] = this.up_all(n10);
                int n11 = this.mk(n6, this.getHigh(n3), this.getHigh(n5));
                this.work_stack[this.work_stack_tos++] = n11;
                int n12 = n11;
                this.work_stack[this.work_stack_tos - 1] = this.up_all(n12);
                n3 = this.mk(n8, n10, n12);
            } else if (n8 < n7) {
                int n13 = this.mk(n6, this.getLow(n3), n5);
                this.work_stack[this.work_stack_tos++] = n13;
                int n14 = n13;
                this.work_stack[this.work_stack_tos - 1] = this.up_all(n14);
                int n15 = this.mk(n6, this.getHigh(n3), n5);
                this.work_stack[this.work_stack_tos++] = n15;
                int n16 = n15;
                this.work_stack[this.work_stack_tos - 1] = this.up_all(n16);
                n3 = this.mk(n8, n14, n16);
            } else {
                int n17 = this.mk(n6, n3, this.getLow(n5));
                this.work_stack[this.work_stack_tos++] = n17;
                int n18 = n17;
                this.work_stack[this.work_stack_tos - 1] = this.up_all(n18);
                int n19 = this.mk(n6, n3, this.getHigh(n5));
                this.work_stack[this.work_stack_tos++] = n19;
                int n20 = n19;
                this.work_stack[this.work_stack_tos - 1] = this.up_all(n20);
                n3 = this.mk(n7, n18, n20);
            }
            this.work_stack_tos -= 4;
        }
        return n3;
    }

    protected final int bed_apply(int n, int n2, int n3) {
        return this.mk(n, n2, n3);
    }

    public final int not(int n) {
        return this.bed_apply(1, n, 0);
    }

    public final int and(int n, int n2) {
        return this.bed_apply(2, n, n2);
    }

    public final int or(int n, int n2) {
        return this.bed_apply(3, n, n2);
    }

    public final int xor(int n, int n2) {
        return this.bed_apply(4, n, n2);
    }

    public final int imply(int n, int n2) {
        return this.bed_apply(5, n, n2);
    }

    public void print(int n) {
        BEDPrinter.print(n, this, this.nodeNames);
    }

    public void printFormula(int n) {
        BEDPrinter.printFormula(this, n, this, this.nodeNames);
    }

    public void printDot(String string, int n) {
        BEDPrinter.printDot(string, n, this, this.nodeNames);
    }

    public static void internal_test() {
        Test.start("BED");
        BED bED = new BED(1000, 100);
        int n = bED.createVar();
        int n2 = bED.createVar();
        int n3 = bED.createVar();
        int n4 = bED.ref(bED.not(n));
        int n5 = bED.ref(bED.not(n2));
        int n6 = bED.ref(bED.xor(n, n2));
        int n7 = bED.ref(bED.imply(n3, n4));
        int n8 = bED.ref(bED.or(n6, n7));
        int n9 = bED.ref(bED.or(n, n2));
        int n10 = bED.ref(bED.and(n, n2));
        Test.check(bED.not(0) == 1, "NOT 0 = 1");
        Test.check(bED.not(1) == 0, "NOT 1 = 0");
        int n11 = bED.ref(bED.not(0));
        int n12 = bED.ref(bED.not(1));
        Test.check(bED.not(n11) == 0, "NOT NOT 0 = 0");
        Test.check(bED.not(n12) == 1, "NOT NOT 1 = 1");
        Test.check(bED.and(n, 0) == 0, "a & 0 = 0");
        Test.check(bED.and(0, 0) == 0, "0 & 0 = 0");
        Test.check(bED.and(1, 0) == 0, "1 & 0 = 0");
        Test.check(bED.and(0, 1) == 0, "0 & 1 = 0");
        Test.check(bED.and(0, n) == 0, "0 & a = 0");
        Test.check(bED.and(n, 1) == n, "a & 1 = a");
        Test.check(bED.and(n, n) == n, "a & a = a");
        Test.check(bED.or(n, 0) == n, "a OR 0 = a");
        Test.check(bED.or(0, 0) == 0, "0 OR 0 = 0");
        Test.check(bED.or(1, 0) == 1, "1 OR 0 = 1");
        Test.check(bED.or(0, 1) == 1, "0 OR 1 = 1");
        Test.check(bED.or(0, n) == n, "0 OR a = a");
        Test.check(bED.or(n, 1) == 1, "a OR 1 = 1");
        Test.check(bED.or(n, n) == n, "a OR a = a");
        Test.check(bED.xor(0, 0) == 0, "0 XOR 0 = 0");
        Test.check(bED.xor(0, 1) == 1, "0 XOR 1 = 1");
        Test.check(bED.xor(1, 0) == 1, "1 XOR 0 = 1");
        Test.check(bED.xor(1, 1) == 0, "1 XOR 1 = 0");
        Test.check(bED.xor(n, 0) == n, "a XOR 0 = a");
        Test.check(bED.xor(0, n) == n, "0 XOR a = a");
        Test.check(bED.xor(n, 1) == n4, "a XOR 1 = ~a");
        Test.check(bED.xor(1, n) == n4, "1 XOR a = ~a");
        Test.check(bED.xor(n, n) == 0, "a XOR a = 0");
        Test.check(bED.imply(0, 0) == 1, "0 imply 0 = 1");
        Test.check(bED.imply(0, 1) == 1, "0 imply 1 = 1");
        Test.check(bED.imply(1, 0) == 0, "1 imply 0 = 0");
        Test.check(bED.imply(1, 1) == 1, "1 imply 1 = 1");
        Test.check(bED.imply(0, n) == 1, "0 imply a = 1");
        Test.check(bED.imply(n, 1) == 1, "a imply 1 = 1");
        Test.check(bED.imply(1, n) == n, "1 imply a = a");
        Test.check(bED.imply(n, 0) == n4, "a imply 0 = ~a");
        int n13 = BED.MAKE_VAR(bED.getVariable(n));
        int n14 = BED.MAKE_VAR(bED.getVariable(n2));
        int n15 = bED.ref(bED.mk(n13, n2, 1));
        int n16 = bED.ref(bED.mk(n14, n, 1));
        int n17 = bED.ref(bED.mk(n13, 0, n2));
        int n18 = bED.ref(bED.mk(n14, 0, n));
        Test.checkEquality(n15, bED.up_one(n, n9), "up_one (1)");
        Test.checkEquality(n16, bED.up_one(n2, n9), "up_one (2)");
        Test.checkEquality(n17, bED.up_one(n, n10), "up_one (3)");
        Test.checkEquality(n18, bED.up_one(n2, n10), "up_one (4)");
        Test.end();
    }

    public static void main(String[] stringArray) {
        BED.internal_test();
    }
}

