/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.bdd.BDD;
import jdd.util.JDDConsole;
import jdd.util.Options;

public class Adder
extends BDD {
    private int N;
    private int[] ainp;
    private int[] binp;
    private int[] not_ainp;
    private int[] not_binp;
    private int[] co;
    private int[] xout;

    public Adder(int n) {
        super(505 + n, 2000);
        this.N = n;
        this.ainp = new int[n];
        this.binp = new int[n];
        this.not_ainp = new int[n];
        this.not_binp = new int[n];
        this.co = new int[n];
        this.xout = new int[n];
        for (int i = 0; i < n; ++i) {
            this.ainp[i] = this.createVar();
            this.binp[i] = this.createVar();
            this.not_ainp[i] = this.ref(this.not(this.ainp[i]));
            this.not_binp[i] = this.ref(this.not(this.binp[i]));
        }
        this.build_adder();
    }

    private void build_adder() {
        for (int i = 0; i < this.N; ++i) {
            if (i > 0) {
                int n = this.ref(this.xor(this.ainp[i], this.binp[i]));
                this.xout[i] = this.ref(this.xor(n, this.co[i - 1]));
                this.deref(n);
                n = this.ref(this.and(this.ainp[i], this.binp[i]));
                int n2 = this.ref(this.and(this.ainp[i], this.co[i - 1]));
                int n3 = this.ref(this.or(n, n2));
                this.deref(n);
                this.deref(n2);
                int n4 = this.ref(this.and(this.binp[i], this.co[i - 1]));
                this.co[i] = this.ref(this.or(n3, n4));
                this.deref(n4);
                this.deref(n3);
                continue;
            }
            this.xout[i] = this.ref(this.xor(this.ainp[i], this.binp[i]));
            this.co[i] = this.ref(this.and(this.ainp[i], this.binp[i]));
        }
    }

    public void dump() {
        for (int i = 0; i < this.N; ++i) {
            System.out.println("Out[" + i + "]: " + this.nodeCount(this.xout[i]) + " nodes");
        }
    }

    private int setval(int n, boolean bl) {
        int n2 = 1;
        for (int i = 0; i < this.N; ++i) {
            n2 = (n & 1) != 0 ? this.andTo(n2, bl ? this.ainp[i] : this.binp[i]) : this.andTo(n2, bl ? this.not_ainp[i] : this.not_binp[i]);
            n >>>= 1;
        }
        return n2;
    }

    private boolean test_vector(int n, int n2, int n3, int n4) {
        int n5 = n3 + n4;
        for (int i = 0; i < this.N; ++i) {
            int n6 = this.ref(this.and(n, n2));
            boolean bl = (n6 = this.andTo(n6, this.xout[i])) == 0 && (n5 & 1) != 0 || n6 != 0 && (n5 & 1) == 0;
            this.deref(n6);
            if (bl) {
                JDDConsole.out.println("resv = " + n6 + ", res = " + n5);
                return false;
            }
            n5 >>>= 1;
        }
        return true;
    }

    public boolean test_adder() {
        int n = 1 << this.N;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = this.setval(i, true);
                int n3 = this.setval(j, false);
                boolean bl = this.test_vector(n2, n3, i, j);
                this.deref(n2);
                this.deref(n3);
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-t")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-d")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    bl3 = true;
                    continue;
                }
                n = Integer.parseInt(stringArray[i]);
            }
            Options.verbose = bl3;
            if (n > 0) {
                JDDConsole.out.print("" + n + "-bit adder, ");
                long l = System.currentTimeMillis();
                Adder adder = new Adder(n);
                if (bl2) {
                    adder.dump();
                }
                if (bl) {
                    JDDConsole.out.print("Testing...");
                    JDDConsole.out.println(adder.test_adder() ? " PASSED" : "FAILED!");
                }
                long l2 = System.currentTimeMillis();
                JDDConsole.out.println(" " + (l2 - l) + " [ms]");
                if (bl3) {
                    adder.showStats();
                }
                adder.cleanup();
                return;
            }
        }
        JDDConsole.out.println("Usage: java jdd.examples.Adder [-t] [-d] [-v] <number of bits>");
        JDDConsole.out.println("\t -t    test adder (slow)");
        JDDConsole.out.println("\t -d    dump BDD size");
        JDDConsole.out.println("\t -v    be verbose");
    }
}

