/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import jdd.util.BottomWeightedObject;
import jdd.util.WeightedObject;

public class BinaryHeap {
    private static BottomWeightedObject bottom = new BottomWeightedObject();
    private int max = 32;
    private int curr = 0;
    private boolean order_ok = true;
    private WeightedObject[] array = new WeightedObject[this.max + 1];

    public BinaryHeap() {
        this.array[0] = bottom;
    }

    public void insert(WeightedObject weightedObject) {
        if (!this.order_ok) {
            this.toss(weightedObject);
        } else {
            this.check_size();
            int n = ++this.curr;
            while (weightedObject.weight() < this.array[n >> 1].weight()) {
                this.array[n] = this.array[n >> 1];
                n >>= 1;
            }
            this.array[n] = weightedObject;
        }
    }

    public WeightedObject min() {
        if (!this.order_ok) {
            this.fix_heap();
        }
        return this.array[1];
    }

    public WeightedObject deleteMin() {
        WeightedObject weightedObject = this.min();
        this.array[1] = this.array[this.curr];
        this.array[this.curr--] = null;
        this.percolate_down(1);
        return weightedObject;
    }

    public boolean empty() {
        return this.curr == 0;
    }

    public void clear() {
        this.curr = 0;
    }

    public int size() {
        return this.curr;
    }

    public int capacity() {
        return this.max;
    }

    private void fix_heap() {
        for (int i = this.curr / 2; i > 0; ++i) {
            this.percolate_down(i);
        }
        this.order_ok = true;
    }

    private void percolate_down(int n) {
        WeightedObject weightedObject = this.array[n];
        while (n * 2 <= this.curr) {
            int n2 = n << 1;
            if (n2 != this.curr && this.array[n2 + 1].weight() < this.array[n2].weight()) {
                ++n2;
            }
            if (!(this.array[n2].weight() < weightedObject.weight())) break;
            this.array[n] = this.array[n2];
            n = n2;
        }
        this.array[n] = weightedObject;
    }

    private void toss(WeightedObject weightedObject) {
        this.check_size();
        this.array[++this.curr] = weightedObject;
        if (weightedObject.weight() < this.array[this.curr >> 1].weight()) {
            this.order_ok = false;
        }
    }

    private void check_size() {
        if (this.curr == this.max) {
            int n = this.max * 2 + 1;
            WeightedObject[] weightedObjectArray = new WeightedObject[n + 1];
            for (int i = 0; i <= this.curr; ++i) {
                weightedObjectArray[i] = this.array[i];
            }
            this.max = n;
            this.array = weightedObjectArray;
        }
    }
}

