/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata;

import java.util.HashMap;
import jdd.des.automata.Automata;
import jdd.des.automata.Automaton;
import jdd.des.automata.Event;
import jdd.des.automata.State;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class AutomataXMLHandler
extends DefaultHandler {
    private static final int STATE_NONE = 0;
    private static final int STATE_DOCUMENT = 1;
    private static final int STATE_AUTOMATA = 2;
    private static final int STATE_AUTOMATON = 3;
    Automata automata = null;
    private Automaton curr = null;
    private HashMap statemap = new HashMap();
    private HashMap eventmap = new HashMap();
    private int state = 0;

    AutomataXMLHandler() {
    }

    private String safe(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        return string3 != null ? string3 : string2;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("Document")) {
            if (this.state == 1) {
                this.state = 0;
            }
        } else if (string3.equals("Automata") || string3.equals("SupremicaProject")) {
            if (this.state == 2) {
                this.state = 1;
            }
        } else if (string3.equals("Automaton") && this.state == 3) {
            this.state = 2;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("Document")) {
            if (this.state == 0) {
                this.state = 1;
            }
        } else if (string3.equals("Automata") || string3.equals("SupremicaProject")) {
            if (this.state != 1 && this.state != 0) {
                return;
            }
            this.state = 2;
            this.automata = new Automata(attributes.getValue("name"));
        } else if (string3.equals("Automaton")) {
            if (this.state != 2) {
                return;
            }
            this.state = 3;
            String string4 = attributes.getValue("name");
            this.curr = this.automata.add(string4);
            string4 = attributes.getValue("type");
            if (string4 != null) {
                this.curr.setType(string4);
            }
            this.statemap.clear();
            this.eventmap.clear();
        } else if (string3.equals("Event")) {
            if (this.state != 3) {
                return;
            }
            String string5 = attributes.getValue("id");
            String string6 = this.safe(attributes, "label", string5);
            String string7 = attributes.getValue("flags");
            Event event = this.curr.addEvent(string6);
            String string8 = attributes.getValue("cost");
            if (string8 != null) {
                event.setWeight(Double.parseDouble(string8));
            }
            event.setControllable((string8 = attributes.getValue("controllable")) == null || string8.equals("true"));
            string8 = attributes.getValue("observable");
            event.setObservable(string8 == null || string8.equals("true"));
            this.eventmap.put(string5, event);
        } else if (string3.equals("State")) {
            if (this.state != 3) {
                return;
            }
            String string9 = attributes.getValue("id");
            String string10 = this.safe(attributes, "name", string9);
            State state = this.curr.addState(string10);
            String string11 = attributes.getValue("initial");
            if (string11 != null) {
                state.setInitial(string11.equals("true"));
            }
            if ((string11 = attributes.getValue("accepting")) != null) {
                state.setMarked(string11.equals("true"));
            }
            if ((string11 = attributes.getValue("forbidden")) != null) {
                state.setForbidden(string11.equals("true"));
            }
            if ((string11 = attributes.getValue("cost")) != null) {
                state.setWeight(Double.parseDouble(string11));
            }
            this.statemap.put(string9, state);
        } else if (string3.equals("Transition")) {
            if (this.state != 3) {
                return;
            }
            String string12 = attributes.getValue("source");
            String string13 = attributes.getValue("dest");
            String string14 = attributes.getValue("event");
            State state = (State)this.statemap.get(string12);
            State state2 = (State)this.statemap.get(string13);
            Event event = (Event)this.eventmap.get(string14);
            if (state == null || state2 == null || event == null) {
                System.err.println("BAD transition in " + this.curr.getName() + ": (" + string12 + "," + string14 + ") -> " + string13);
            } else {
                this.curr.addTransition(state, state2, event);
            }
        }
    }
}

