/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import jdd.graph.Edge;

public class Node {
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_ROOT = 1;
    public static final int FLAGS_MARKED = 2;
    public static final int FLAGS_TERMINAL = 4;
    public static final int FLAGS_BAD = 8;
    public static final int FLAGS_WEIGTHED = 16;
    public static final int FLAGS_LABLED = 32;
    public static final int FLAGS_INTERNAL1 = 64;
    public static final int FLAGS_INTERNAL2 = 128;
    public int id;
    public int flags;
    public int extra1;
    public int extra2;
    public int extraindex;
    public double extra3;
    public double extra4;
    public double weight;
    public Edge firstOut;
    public Edge firstIn;
    public String label;

    public Node(int n) {
        this(n, null);
    }

    public Node(int n, String string) {
        this.id = n;
        this.weight = 0.0;
        this.firstOut = null;
        this.firstIn = null;
        this.setLabel(string);
    }

    public void setLabel(String string) {
        this.label = string;
        this.flags = string != null ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public String getLabel() {
        return (this.flags & 0x20) == 0 ? "V" + this.id : this.label;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        this.weight = d;
        this.flags |= 0x10;
    }

    public boolean isWeighted() {
        return (this.flags & 0x10) != 0;
    }

    public int getDegree() {
        int n = 0;
        Edge edge = this.firstOut;
        while (edge != null) {
            ++n;
            edge = edge.next;
        }
        edge = this.firstIn;
        while (edge != null) {
            ++n;
            edge = edge.prev;
        }
        return n;
    }

    public void copyAttributesFrom(Node node) {
        this.flags = node.flags;
        this.extra1 = node.extra1;
        this.extra2 = node.extra2;
        this.extra3 = node.extra3;
        this.extra4 = node.extra4;
        this.weight = node.weight;
    }
}

