/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.dom4j.Element;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.tool.hbm2x.MetaAttributeHelper;

public class MetaAttributeBinder {
    public static MultiMap mergeMetaMaps(Map specific, Map general) {
        MultiHashMap result = new MultiHashMap();
        MetaAttributeHelper.copyMultiMap((MultiMap)result, specific);
        if (general != null) {
            for (String key : general.keySet()) {
                if (specific.containsKey(key)) continue;
                Collection ml = (Collection)general.get(key);
                for (SimpleMetaAttribute element : ml) {
                    if (!element.inheritable) continue;
                    result.put((Object)key, (Object)element);
                }
            }
        }
        return result;
    }

    public static MetaAttribute toRealMetaAttribute(String name, List values) {
        MetaAttribute attribute = new MetaAttribute(name);
        for (SimpleMetaAttribute element : values) {
            attribute.addValue(element.value);
        }
        return attribute;
    }

    public static MultiMap loadAndMergeMetaMap(Element classElement, MultiMap inheritedMeta) {
        return MetaAttributeBinder.mergeMetaMaps((Map)MetaAttributeBinder.loadMetaMap(classElement), (Map)inheritedMeta);
    }

    protected static MultiMap loadMetaMap(Element element) {
        MultiHashMap result = new MultiHashMap();
        ArrayList metaAttributeList = new ArrayList();
        metaAttributeList.addAll(element.elements("meta"));
        for (Element metaAttrib : metaAttributeList) {
            String attribute = metaAttrib.attributeValue("attribute");
            String value = metaAttrib.getText();
            String inheritStr = metaAttrib.attributeValue("inherit");
            boolean inherit = true;
            if (inheritStr != null) {
                inherit = Boolean.valueOf(inheritStr);
            }
            SimpleMetaAttribute ma = new SimpleMetaAttribute(value, inherit);
            result.put((Object)attribute, (Object)ma);
        }
        return result;
    }

    static class SimpleMetaAttribute {
        String value;
        boolean inheritable = true;

        public SimpleMetaAttribute(String value, boolean inherit) {
            this.value = value;
            this.inheritable = inherit;
        }

        public String toString() {
            return this.value;
        }
    }
}

