package core.exception;


/**
 * 業務例外
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class LogicalException extends RuntimeException {
	/** serialVersionUID */
	private static final long serialVersionUID = -7185810040168410941L;

	/** 復帰値 */
	private final String rc;
	/** ステータスコード */
	private final int scode;

	/**
	 * コンストラクタ
	 * @param msg メッセージ
	 */
	public LogicalException(final String msg) {
		this(msg, null);
	}

	/**
	 * コンストラクタ
	 * @param ret 復帰値
	 * @param msg メッセージ
	 */
	public LogicalException(final String msg, final String ret) {
		super(msg);
		this.rc = ret;
		this.scode = 0;
	}

	/**
	 * コンストラクタ
	 * @param sc ステータスコード
	 */
	public LogicalException(final int sc) {
		this(sc, null);
	}

	/**
	 * コンストラクタ
	 * @param sc ステータスコード
	 * @param msg メッセージ
	 */
	public LogicalException(final int sc, final String msg) {
		super(msg);
		this.rc = null;
		this.scode = sc;
	}

	/**
	 * ファクトリ
	 *
	 * @param ret 復帰値
	 * @return LogicalException
	 */
	public static LogicalException create(final String ret) {
		return new LogicalException(null, ret);
	}

	/**
	 * 復帰値取得
	 *
	 * @return 復帰値
	 */
	public String getReturnCode() {
		return this.rc;
	}

	/**
	 * ステータスコード取得
	 *
	 * @return ステータスコード
	 */
	public int getStatusCode() {
		return this.scode;
	}
}
