package batch.status;

import java.sql.Timestamp;

import core.util.DateUtil;

/**
 * ジョブ詳細管理
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class JobDetail {
	/** identifier field */
	private volatile long jobSeq;

	/** identifier field */
	private int batSeq;

	/** persistent field */
	private int pid;

	/** persistent field */
	private String batName;

	/** persistent field */
	private int batSts;

	/** nullable persistent field */
	private Timestamp startDtm;

	/** nullable persistent field */
	private Timestamp stopDtm;

	/** nullable persistent field */
	private String msgTxt;

	/**
	 * バッチ名取得
	 *
	 * @return バッチ名
	 */
	public String getBatName() {
		return this.batName;
	}

	/**
	 * バッチ名設定
	 *
	 * @param val バッチ名
	 */
	public void setBatName(final String val) {
		this.batName = val;
	}

	/**
	 * バッチ連番取得
	 *
	 * @return バッチ連番
	 */
	public int getBatSeq() {
		return this.batSeq;
	}

	/**
	 * バッチ連番設定
	 *
	 * @param val バッチ連番
	 */
	public void setBatSeq(final int val) {
		this.batSeq = val;
	}

	/**
	 * バッチステータス取得
	 *
	 * @return バッチステータス
	 */
	public int getBatSts() {
		return this.batSts;
	}

	/**
	 * バッチステータス設定
	 *
	 * @param val バッチステータス
	 */
	public void setBatSts(final int val) {
		this.batSts = val;
	}

	/**
	 * ジョブ連番取得
	 *
	 * @return ジョブ連番
	 */
	public long getJobSeq() {
		return this.jobSeq;
	}

	/**
	 * ジョブ連番設定
	 *
	 * @param val ジョブ連番
	 */
	public void setJobSeq(final long val) {
		this.jobSeq = val;
	}

	/**
	 * 処理開始日時取得
	 *
	 * @return 処理開始日時
	 */
	public Timestamp getStartDtm() {
		return DateUtil.copyOf(this.startDtm);
	}

	/**
	 * 処理開始日時設定
	 *
	 * @param val 処理開始日時
	 */
	public void setStartDtm(final Timestamp val) {
		this.startDtm = DateUtil.copyOf(val);
	}

	/**
	 * メッセージテキスト取得
	 *
	 * @return メッセージテキスト
	 */
	public String getMsgTxt() {
		return this.msgTxt;
	}

	/**
	 * メッセージテキスト設定
	 *
	 * @param val メッセージテキスト
	 */
	public void setMsgTxt(final String val) {
		this.msgTxt = val;
	}

	/**
	 * PID取得
	 *
	 * @return PID
	 */
	public int getPid() {
		return this.pid;
	}

	/**
	 * PID設定
	 *
	 * @param val PID
	 */
	public void setPid(final int val) {
		this.pid = val;
	}

	/**
	 * 処理終了日時取得
	 *
	 * @return 処理終了日時
	 */
	public Timestamp getStopDtm() {
		return DateUtil.copyOf(this.stopDtm);
	}

	/**
	 * 処理終了日時設定
	 *
	 * @param val 処理終了日時
	 */
	public void setStopDtm(final Timestamp val) {
		this.stopDtm = DateUtil.copyOf(val);
	}
}
