package batch.status;

import java.sql.Connection;
import java.util.List;

/**
 * ジョブ管理マスタ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface JobMasterInfo {
	/**
	 * ジョブ管理マスタ取得
	 *
	 * @param conn コネクション
	 * @return リスト
	 */
	List<JobMaster> getJobMasterInfoAll(Connection conn);

	/**
	 * ジョブ情報取得
	 *
	 * @param conn コネクション
	 * @param jobid ジョブID
	 * @return ジョブ情報
	 */
	JobMaster getJobMasterInfo(Connection conn, String jobid);
}
