package online.context.check;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import online.context.ActionParameter;
import online.context.session.SessionUser;
import online.model.UniModel;

/**
 * 入力チェック親
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class ItemCheckBase {

	/** アクションパラメタ */
	private ActionParameter ap = null;
	/** セションユーザ情報 */
	private SessionUser su = null;
	/** 汎用モデル */
	private UniModel um = null;
	/** 参照パラメタキーセット */
	private Map<String, String[]> ref = null;
	/** トップメッセージ */
	private List<String> mlist = null;
	/** トップメッセージステータス */
	private List<String> slist = null;
	/** チェック対象判断ラムダ式 */
	private Predicate<Integer> pred = null;

	/**
	 * アクションパラメタ設定
	 *
	 * @param param 汎用フォーム
	 */
	final void setActionParameter(final ActionParameter param) {
		this.ap = param;
	}

	/**
	 * アクションパラメタ取得
	 * @return アクションパラメタ
	 */
	protected ActionParameter getActionParameter() {
		return this.ap;
	}

	/**
	 * セションユーザ情報設定
	 * @param user セションユーザ情報
	 */
	final void setSessionUser(final SessionUser user) {
		this.su = user;
	}

	/**
	 * セションユーザ情報取得
	 * @return セションユーザ情報
	 */
	protected SessionUser getSessionUser() {
		return this.su;
	}

	/**
	 * 汎用モデル設定
	 * @param model 汎用モデル
	 */
	final void setUniModel(final UniModel model) {
		this.um = model;
	}

	/**
	 * 汎用モデル取得
	 * @return 汎用モデル
	 */
	protected UniModel getUniModel() {
		return this.um;
	}

	/**
	 * チェック対象判断ラムダ式設定
	 *
	 * @param predicate チェック対象判断ラムダ式
	 */
	public void setPredicate(final Predicate<Integer> predicate) {
		this.pred = predicate;
	}

	/**
	 * チェック対象判断ラムダ式取得
	 *
	 * @return predicate チェック対象判断ラムダ式
	 */
	protected Predicate<Integer> getPredicate() {
		return this.pred;
	}

	/**
	 * メッセージリスト設定
	 * @param m メッセージリスト
	 * @param s ステータスリスト
	 */
	final void setMessageList(final List<String> m, final List<String> s) {
		this.mlist = m;
		this.slist = s;
	}

	/**
	 * メッセージリスト取得
	 * @return メッセージリスト
	 */
	protected List<String> getMessageList() {
		return this.mlist;
	}

	/**
	 * ステータスリスト取得
	 * @return ステータスリスト
	 */
	protected List<String> getStatusList() {
		return this.slist;
	}

	/**
	 * 参照パラメタキーセット設定
	 *
	 * @param val 参照パラメタキーセット
	 */
	final void setReferenceMap(final Map<String, String[]> val) {
		this.ref = val;
	}

	/**
	 * パラメタ値取得
	 *
	 * @param key キー
	 * @return パラメタ値
	 */
	protected String[] getArrayParameter(final String key) {
		String[] ret = this.ref.get(key);
		if (ret == null) {
			ret = this.ap.getParameter().getArrayValue(key);
			this.ref.put(key, ret);
		}
		return ret;
	}
}
