package online.view.tag;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.logging.log4j.LogManager;

import core.config.Factory;
import online.view.ViewUtil;
import online.view.model.ViewMap;

/**
 * タグライブラリ用ユーティリティ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class BaseTag extends TagSupport {
	/** serivalVersionUID */
	private static final long serialVersionUID = -7792897218713999276L;

	/**
	 * リクエスト取得
	 * @return リクエスト
	 */
	protected HttpServletRequest getRequest() {
		return HttpServletRequest.class.cast(this.pageContext.getRequest());
	}

	/**
	 * レスポンス取得
	 * @return レスポンス
	 */
	protected HttpServletResponse getResponse() {
		return HttpServletResponse.class.cast(this.pageContext.getResponse());
	}

	/**
	 * 出力処理
	 *
	 * @param var 変数
	 * @param obj 出力オブジェクト
	 * @return 出力結果
	 */
	protected boolean output(final String var, final Object obj) {
		return output(var, obj, false);
	}

	/**
	 * 出力処理
	 *
	 * @param var 変数
	 * @param obj 出力オブジェクト
	 * @param bool 改行フラグ
	 * @return 出力結果
	 */
	protected boolean output(final String var, final Object obj, final boolean bool) {
		try {
			if (obj != null) {
				if (var == null) {
					if (bool) {
						// 出力
						this.pageContext.getOut().println(obj);
					} else {
						// 出力
						this.pageContext.getOut().print(obj);
					}
				} else {
					// 変数設定
					this.pageContext.setAttribute(var, obj);
				}
			}
			return true;
		} catch (final IOException ex) {
			LogManager.getLogger().info(ex.getMessage());
			return false;
		}
	}

	/**
	 * 汎用マップ取得
	 *
	 * @return 汎用マップ
	 */
	protected ViewMap getViewMap() {
		ViewMap ret = ViewMap.class.cast(this.pageContext.getAttribute(
						ViewUtil.ATTR_MAP, PageContext.REQUEST_SCOPE));
		if (ret == null) {
			ret = Factory.create(ViewMap.class);
			ret.setMap(new HashMap<String, Serializable>());
			ret.setResponse(getResponse());
		}
		return ret;
	}
}
