package project.batch;

import java.sql.Timestamp;
import java.util.Objects;

import project.common.master.AppConfig;
import batch.base.BatchParameter;
import batch.base.BatchParameterImpl;
import core.config.Env;
import core.config.Factory;

/**
 * バッチパラメタ実装
 *
 * @author Tadashi Nakayama
 */
public final class ProjectParameter implements BatchParameter {

	/** バッチ実行ユーザ */
	private static final String BATCH_USER = "Batch.User";
	/** 環境種別 */
	private static final String KANKYO_SBT = "BATCH";
	/** 詳細コード バッチユーザ */
	private static final String DETAIL_USER = "USER";

	/** ジョブID */
	private String jobId = "";

	/** パラメタオブジェクト */
	private final BatchParameterImpl param = new BatchParameterImpl();

	/**
	 * コンストラクタ
	 */
	public ProjectParameter() {
		//		AppConfig cfg = Factory.instantiate(AppConfig.class);
		//		cfg.init();
	}

	/**
	 * コマンドラインパラメタ設定
	 *
	 * @param args 引数
	 */
	@Override
	public void setCommandParameter(final String... args) {
		this.param.setCommandParameter(args);
	}

	/**
	 * オンライン引数設定
	 *
	 * @param name バッチ名
	 * @param datetime 開始日時
	 * @return 設定正常終了の場合 true を返す。
	 */
	@Override
	public boolean setupOnline(final String name, final Timestamp datetime) {
		return this.param.setupOnline(name, datetime);
	}

	/**
	 * @see batch.base.BatchParameter#getIp()
	 */
	@Override
	public String getIp() {
		return this.param.getIp();
	}

	/**
	 * @see batch.base.BatchParameter#getJobDtlSeq()
	 */
	@Override
	public int getJobDtlSeq() {
		return this.param.getJobDtlSeq();
	}

	/**
	 * @see batch.base.BatchParameter#getJobSeq()
	 */
	@Override
	public long getJobSeq() {
		return this.param.getJobSeq();
	}

	/**
	 * @see batch.base.BatchParameter#getPid()
	 */
	@Override
	public int getPid() {
		return this.param.getPid();
	}

	/**
	 * @see batch.base.BatchParameter#getJobName()
	 */
	@Override
	public String getJobName() {
		return this.param.getJobName();
	}

	/**
	 * @see batch.base.BatchParameter#getUid()
	 */
	@Override
	public String getUid() {
		if (getJobSeq() == 0L) {
			if (Objects.toString(this.param.getUid(), "").isEmpty()) {
				final AppConfig cfg = Factory.create(AppConfig.class);
				String ret = cfg.getValue(this.jobId, KANKYO_SBT, DETAIL_USER);
				if (Objects.toString(ret, "").isEmpty()) {
					ret = Env.getEnv(BATCH_USER);
				}
				return ret;
			}
		}
		return this.param.getUid();
	}

	/**
	 * @see batch.base.BatchParameter#getParameter()
	 */
	@Override
	public String[] getParameter() {
		return this.param.getParameter();
	}

	/**
	 * ジョブID設定
	 *
	 * @param val ジョブID
	 */
	public void setJobId(final String val) {
		this.jobId = val;
	}

	/**
	 * @see batch.base.BatchParameter#setDateTime(java.sql.Timestamp)
	 */
	@Override
	public void setDateTime(final Timestamp val) {
		this.param.setDateTime(val);
	}

	/**
	 * @see batch.base.BatchParameter#getDateTime()
	 */
	@Override
	public Timestamp getDateTime() {
		return this.param.getDateTime();
	}
}
