package project.common.master;

import java.util.List;

/**
 * アプリケーション環境保持
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface AppConfig {
	/**
	 * 初期処理を行う。
	 *
	 */
	void initialize();

	/**
	 * 選択項目取得
	 *
	 * @param kinoId 機能ID
	 * @param kankyoSbt 環境種別
	 * @param detailSbt 詳細種別
	 * @return 環境設定値
	 */
	String getValue(String kinoId, String kankyoSbt, String detailSbt);

	/**
	 * 選択項目取得
	 *
	 * @param kinoId 機能ID
	 * @param kankyoSbt 環境種別
	 * @param detailSbt 詳細種別
	 * @param def デフォルト
	 * @return 環境設定値
	 */
	String getValue(String kinoId, String kankyoSbt, String detailSbt, String def);

	/**
	 * 選択項目取得
	 *
	 * @param kinoId 機能ID
	 * @param kankyoSbt 環境種別
	 * @param detailSbt 詳細種別
	 * @param def デフォルト
	 * @return 環境設定値
	 */
	int getValue(String kinoId, String kankyoSbt, String detailSbt, int def);

	/**
	 * 選択項目存在確認
	 *
	 * @param kinoId 機能ID
	 * @param kankyoSbt 環境種別
	 * @param detailSbt 詳細種別
	 * @return 存在した場合 true を返す。
	 */
	boolean hasValue(String kinoId, String kankyoSbt, String detailSbt);

	/**
	 * 選択環境項目取得
	 * 機能ＩＤと環境種別を条件に、該当するレコードの内容をリストにして返却する。
	 *
	 * @param kinoId 機能ID
	 * @param kankyoSbt 環境種別
	 * @return 設定値一覧リスト
	 */
	List<String> getValueList(String kinoId, String kankyoSbt);

	/**
	 * 選択環境項目取得
	 * 機能ＩＤと環境種別を条件に、該当するレコードのキー値をリストにして返却する。
	 *
	 * @param kinoId 機能ID
	 * @param kankyoSbt 環境種別
	 * @return 設定値一覧リスト
	 */
	List<String> getDetailList(String kinoId, String kankyoSbt);
}
