CREATE TABLE TR_SEARCH_PATTERN
(
    ID                          NUMBER(10)     NOT NULL,
    PATTERN_NAME                VARCHAR2(256)  NOT NULL,
    GID                         VARCHAR2(16)   NOT NULL,
    QUERY                       VARCHAR2(4000) NOT NULL,
    PREFERENCE                  CHAR(1)        NOT NULL,
    GAMEN_NAME                  VARCHAR2(16)   NOT NULL,
    INSERT_DATETIME             TIMESTAMP      NOT NULL,
    INSERT_ID                   VARCHAR2(32)   NOT NULL,
    UPDATE_DATETIME             TIMESTAMP      NOT NULL,
    UPDATE_ID                   VARCHAR2(32)   NOT NULL,
    VERSION                     NUMBER(6)      NOT NULL DEFAULT 1,
    CONSTRAINT TR_SEARCH_PATTERN_PK PRIMARY KEY (ID),
    CONSTRAINT TR_SEARCH_PATTERN_UNIQUE UNIQUE (PATTERN_NAME, GID, INSERT_ID)
)
;

COMMENT ON TABLE TR_SEARCH_PATTERN IS 'p^[Ǘ';
COMMENT ON COLUMN TR_SEARCH_PATTERN.ID IS 'ID';
COMMENT ON COLUMN TR_SEARCH_PATTERN.PATTERN_NAME IS 'p^[';
COMMENT ON COLUMN TR_SEARCH_PATTERN.GID IS 'ID';
COMMENT ON COLUMN TR_SEARCH_PATTERN.QUERY IS 'NG';
COMMENT ON COLUMN TR_SEARCH_PATTERN.PREFERENCE IS 'DtO';
COMMENT ON COLUMN TR_SEARCH_PATTERN.GAMEN_NAME IS 'ʖ';
COMMENT ON COLUMN TR_SEARCH_PATTERN.INSERT_DATETIME IS '쐬';
COMMENT ON COLUMN TR_SEARCH_PATTERN.INSERT_ID IS '쐬';
COMMENT ON COLUMN TR_SEARCH_PATTERN.UPDATE_DATETIME IS 'XV';
COMMENT ON COLUMN TR_SEARCH_PATTERN.UPDATE_ID IS 'XV';
COMMENT ON COLUMN TR_SEARCH_PATTERN.VERSION IS 'o[W';
