CREATE TABLE MS_GENERIC_CSV_DTL
(
    ID                          BIGINT PRIMARY KEY,
    DEFINE_NO                   BIGINT        NOT NULL,
    DTL_NO                      INTEGER      NOT NULL,
    LOGICAL_ITEM_NAME           VARCHAR(100) NOT NULL,
    PHYSICAL_ITEM_NAME          VARCHAR(100) NOT NULL,
    INSERT_DATETIME             TIMESTAMP    NOT NULL,
    INSERT_ID                   VARCHAR(32)  NOT NULL,
    UPDATE_DATETIME             TIMESTAMP    NOT NULL,
    UPDATE_ID                   VARCHAR(32)  NOT NULL,
    VERSION                     INTEGER      NOT NULL DEFAULT 1,
    CONSTRAINT MS_GENERIC_CSV_DTL_UIX01 UNIQUE (DEFINE_NO, DTL_NO)
)
;

COMMENT ON TABLE MS_GENERIC_CSV_DTL IS '汎用CSV管理詳細';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.ID IS 'キー';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.DEFINE_NO IS '定義番号';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.DTL_NO IS '詳細番号';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.LOGICAL_ITEM_NAME IS '表示項目名';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.PHYSICAL_ITEM_NAME IS '項目名';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.INSERT_ID IS '作成ID';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.UPDATE_ID IS '更新ID';
COMMENT ON COLUMN MS_GENERIC_CSV_DTL.VERSION IS 'バージョン';
