package project.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import javassist.ClassClassPath;
import javassist.ClassPool;
import online.listener.ContextListener;
import online.listener.S2ContextListener;

/**
 * WebContextListener
 * @author Tadashi Nakayama
 */
public class WebContextListener implements ServletContextListener {

	/** ContextListener */
	private final ContextListener cl = new ContextListener();

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextDestroyed(final ServletContextEvent arg0) {
		this.cl.contextDestroyed(arg0);

		new S2ContextListener().contextDestroyed(arg0);
	}

	/**
	 * @see javax.servlet.ServletContextListener
	 * #contextInitialized(javax.servlet.ServletContextEvent)
	 */
	@Override
	public void contextInitialized(final ServletContextEvent arg0) {
		this.cl.contextInitialized(arg0);

		final ClassPool pool = ClassPool.getDefault();
		pool.appendClassPath(new ClassClassPath(this.getClass()));
	}
}
