package project.check.existence;

import java.util.Objects;
import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import project.check.BaseCheck;
import project.master.MsgUtil;


/**
 * どれか一つ以上必須入力チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class AnyOneCheck extends BaseCheck implements ItemCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public AnyOneCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public AnyOneCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = super.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			boolean one = false;
			final String[] val = super.getArrayParameter(item);
			if (val != null) {
				for (final String str : val) {
					if (!Objects.toString(str, "").isEmpty()) {
						one = true;
						break;
					}
				}
			}

			if (!one) {
				if (!MsgUtil.hasItemMessage(super.getUniModel(), item)) {
					super.addTopMessage(this.mid, this.prm);
				}
				check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(0))));
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
