package project.check.existence;

import java.util.Objects;
import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;

/**
 * 文字必須チェック（nullはOK）
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class BeingCheck extends BaseCheck implements ItemCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public BeingCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public BeingCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = super.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			final String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (Objects.toString(val[j], "").isEmpty()) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
