package project.svc.auth;

import java.sql.Timestamp;
import java.util.Date;

/**
 * 認証
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface Authentication {

	/**
	 * ログオンチェック
	 *
	 * @param uid ユーザID
	 * @param sid セションID
	 * @return 正常なら true
	 */
	boolean checkLogon(String uid, String sid);

	/**
	 * ログオン処理
	 *
	 * @param uid ユーザID
	 * @param pwd パスワード
	 * @return 成功なら true
	 */
	boolean logon(String uid, String pwd);

	/**
	 * ユーザのステータスを更新/追加
	 *
	 * @param uid ユーザID
	 * @param now 現在日時
	 * @param sid セションID
	 * @param interval 最大無効間隔
	 * @return アクションセションID
	 */
	SessionInfo updateStatus(String uid, Date now, String sid, int interval);

	/**
	 * ログオフ
	 *
	 * @param uid ユーザID
	 * @param sid セションID
	 * @param time 日時
	 */
	void logoff(String uid, String sid, Timestamp time);

	/**
	 * アクション時間を設定する。
	 *
	 * @param uid ユーザID
	 * @param now 現在日時
	 * @param sid セションID
	 */
	void setActionTime(String uid, Date now, String sid);

	/**
	 * チケット追加
	 *
	 * @param uid ユーザID
	 * @return チケット
	 */
	String addTicket(String uid);

	/**
	 * チケット削除処理
	 *
	 * @param uid ユーザID
	 * @param val チケット
	 * @return 存在していて削除された場合 true 存在しない場合等はfalse
	 */
	boolean removeTicket(String uid, String val);
}
