package online.model;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestModelUtil
 *
 */
public class TestModelUtil {

	/**
	 * Bean項目→UniModel設定テスト１
	 */
	@Test
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "String");
		ModelUtil.setBeanItemValue(um, bean, "StringArray");

		Assert.assertTrue(um.containsKey("String"));
		Assert.assertFalse(um.hasValue("String"));
		Assert.assertEquals("", um.getString("String"));
		Assert.assertEquals(0, um.getArraySize("String"));
		Assert.assertEquals(0, um.getStringArray("String").length);
		Assert.assertFalse(um.isArrayValue("String"));

		Assert.assertTrue(um.containsKey("StringArray"));
		Assert.assertFalse(um.hasValue("StringArray"));
		Assert.assertEquals("", um.getString("StringArray"));
		Assert.assertEquals(0, um.getArraySize("StringArray"));
		Assert.assertEquals(0, um.getStringArray("StringArray").length);
		Assert.assertTrue(um.isArrayValue("StringArray"));
	}

	/**
	 * Bean項目→UniModel設定テスト２
	 */
	@Test
	public void setBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setString("AAAAA");
		bean.setStringArray(new String[]{"AAAAA"});
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "String");
		ModelUtil.setBeanItemValue(um, bean, "StringArray");

		Assert.assertTrue(um.containsKey("String"));
		Assert.assertTrue(um.hasValue("String"));
		Assert.assertEquals("AAAAA", um.getString("String"));
		Assert.assertEquals(1, um.getArraySize("String"));
		Assert.assertEquals(1, um.getStringArray("String").length);
		Assert.assertFalse(um.isArrayValue("String"));

		Assert.assertTrue(um.containsKey("StringArray"));
		Assert.assertTrue(um.hasValue("StringArray"));
		Assert.assertEquals("AAAAA", um.getString("StringArray"));
		Assert.assertEquals(1, um.getArraySize("StringArray"));
		Assert.assertEquals(1, um.getStringArray("StringArray").length);
		Assert.assertTrue(um.isArrayValue("StringArray"));
	}


	/**
	 * Bean項目→UniModel追加テスト１
	 */
	@Test
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "String");
		ModelUtil.addBeanItemValue(um, bean, "StringArray");

		Assert.assertTrue(um.containsKey("String"));
		Assert.assertTrue(um.hasValue("String"));
		Assert.assertEquals("", um.getString("String"));
		Assert.assertEquals(1, um.getArraySize("String"));
		Assert.assertEquals(1, um.getStringArray("String").length);
		Assert.assertFalse(um.isArrayValue("String"));

		Assert.assertTrue(um.containsKey("StringArray"));
		Assert.assertTrue(um.hasValue("StringArray"));
		Assert.assertNull(um.getStringArray("StringArray")[0]);
		Assert.assertEquals(1, um.getArraySize("StringArray"));
		Assert.assertEquals(1, um.getStringArray("StringArray").length);
		Assert.assertTrue(um.isArrayValue("StringArray"));
	}

	/**
	 * Bean項目→UniModel追加テスト２
	 */
	@Test
	public void addBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setString("AAAAA");
		bean.setStringArray(new String[]{"AAAAA"});
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "String");
		ModelUtil.addBeanItemValue(um, bean, "StringArray");

		Assert.assertTrue(um.containsKey("String"));
		Assert.assertTrue(um.hasValue("String"));
		Assert.assertEquals("AAAAA", um.getString("String"));
		Assert.assertEquals(1, um.getArraySize("String"));
		Assert.assertEquals(1, um.getStringArray("String").length);
		Assert.assertFalse(um.isArrayValue("String"));

		Assert.assertTrue(um.containsKey("StringArray"));
		Assert.assertTrue(um.hasValue("StringArray"));
		Assert.assertEquals("AAAAA", um.getStringArray("StringArray")[0]);
		Assert.assertEquals(1, um.getArraySize("StringArray"));
		Assert.assertEquals(1, um.getStringArray("StringArray").length);
		Assert.assertTrue(um.isArrayValue("StringArray"));
	}


	/**
	 * UniModel→Bean設定テスト（空）
	 */
	@Test
	public void setModelValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト(String->String)
	 */
	@Test
	public void setModelValueTest2() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", "AAAAA");
		um.setValue("StringArray", new String[]{"AAAAA"});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("AAAAA", bean.getString());
		Assert.assertEquals("AAAAA", bean.getStringArray()[0]);
	}

	/**
	 * UniModel→Bean設定テスト(String->Boolean)
	 */
	@Test
	public void setModelValueTest3() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBooleanArray", new String[]{"ZZZZ", "TRUE"});
		um.setValue("BooleanArray", new String[]{"ZZZZ", "TRUE"});
		ModelUtil.setModelValue(bean, um);

		Assert.assertFalse(bean.isPrimitiveBooleanArray()[0]);
		Assert.assertTrue(bean.isPrimitiveBooleanArray()[1]);
		Assert.assertEquals(Boolean.FALSE, bean.isBooleanArray()[0]);
		Assert.assertEquals(Boolean.TRUE, bean.isBooleanArray()[1]);
	}

	/**
	 * UniModel→Bean設定テスト(String->Integer)
	 */
	@Test
	public void setModelValueTest4() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveIntegerArray", new String[]{"111", "222"});
		um.setValue("IntegerArray", new String[]{"333", "444"});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals(111, bean.getPrimitiveIntegerArray()[0]);
		Assert.assertEquals(222, bean.getPrimitiveIntegerArray()[1]);
		Assert.assertEquals(Integer.valueOf(333), bean.getIntegerArray()[0]);
		Assert.assertEquals(Integer.valueOf(444), bean.getIntegerArray()[1]);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->空)
	 */
	@Test
	public void setModelValueTest5() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String[])null);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->空配列)
	 */
	@Test
	public void setModelValueTest6() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", new String[0]);
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->空)
	 */
	@Test
	public void setModelValueTest7() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String)null);

		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(1, bean.getStringArray().length);
		Assert.assertNull(bean.getStringArray()[0]);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->文字列)
	 */
	@Test
	public void setModelValueTest8() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", "aaaa");
		um.setValue("StringArray", "bbbb");

		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("aaaa", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(1, bean.getStringArray().length);
		Assert.assertEquals("bbbb", bean.getStringArray()[0]);
	}


	/**
	 * UniModel→Bean設定テスト(空)
	 */
	@Test
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→String)
	 */
	@Test
	public void setModelValueTest11() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", new String[]{"ZZZZ", "AAAAA"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals("AAAAA", bean.getString());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→Boolean)
	 */
	@Test
	public void setModelValueTest12() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", new String[]{"ZZZZ", "TRUE"});
		um.setValue("Boolean", new String[]{"ZZZZ", "TRUE"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBooleanArray());
		Assert.assertTrue(bean.isPrimitiveBoolean());
		Assert.assertEquals(Boolean.TRUE, bean.isBoolean());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→int)
	 */
	@Test
	public void setModelValueTest13() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new String[]{"1111", "2,222"});
		um.setValue("Integer", new String[]{"3333", "4444"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
		Assert.assertEquals(2222, bean.getPrimitiveInteger());
		Assert.assertEquals(Integer.valueOf(4444), bean.getInteger());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→int非数値)
	 */
	@Test
	public void setModelValueTest14() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", new String[]{"1111", ",,"});
		um.setValue("Integer", new String[]{"3333", ","});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getPrimitiveIntegerArray());
		Assert.assertNull(bean.getIntegerArray());
		Assert.assertEquals(0, bean.getPrimitiveInteger());
		Assert.assertNull(bean.getInteger());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→null)
	 */
	@Test
	public void setModelValueTest15() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String[])null);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(String配列→空配列)
	 */
	@Test
	public void setModelValueTest16() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", new String[0]);
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(値無し)
	 */
	@Test
	public void setModelValueTest20() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		final UniModelImpl um = new UniModelImpl();
		um.noValue("String");
		um.noValue("StringArray");
		ModelUtil.setModelValue(bean, um);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト
	 */
	@Test
	public void setModelValueTest21() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});

		final UniModelImpl um = new UniModelImpl();
		um.noValue("String");
		um.noValue("StringArray");

		ModelUtil.setModelValue(bean, um, 0);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());

		bean.setString("aaaa");
		bean.setStringArray(new String[]{"aaaa"});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertNull(bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト
	 */
	@Test
	public void setModelValueTest31() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", new String[]{"aaaa", "bbbb"});
		um.setValue("StringArray", new String[]{"aaaa", "bbbb"});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals("aaaa", bean.getStringArray()[0]);
		Assert.assertEquals("bbbb", bean.getStringArray()[1]);
	}
}
