package online.model;

import org.junit.Assert;
import org.junit.Test;

/**
 * TestModelUtilBoolean
 *
 */
public class TestModelUtilBoolean {

	/**
	 * Bean->UniModel設定 Boolean 空
	 */
	@Test
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.setBeanItemValue(um, bean, "Boolean");
		ModelUtil.setBeanItemValue(um, bean, "BooleanArray");

		Assert.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assert.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assert.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assert.assertFalse(um.hasValue("PrimitiveBooleanArray"));
		Assert.assertNull(um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(0, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(0, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));

		Assert.assertTrue(um.containsKey("Boolean"));
		Assert.assertFalse(um.hasValue("Boolean"));
		Assert.assertNull(um.getBoolean("Boolean"));
		Assert.assertEquals(0, um.getArraySize("Boolean"));
		Assert.assertEquals(0, um.getBooleanArray("Boolean").length);
		Assert.assertFalse(um.isArrayValue("Boolean"));

		Assert.assertTrue(um.containsKey("BooleanArray"));
		Assert.assertFalse(um.hasValue("BooleanArray"));
		Assert.assertNull(um.getBoolean("BooleanArray"));
		Assert.assertEquals(0, um.getArraySize("BooleanArray"));
		Assert.assertEquals(0, um.getBooleanArray("BooleanArray").length);
		Assert.assertTrue(um.isArrayValue("BooleanArray"));
	}

	/**
	 * Bean->UniModel設定 boolean 配列
	 */
	@Test
	public void setBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setPrimitiveBoolean(true);
		bean.setPrimitiveBooleanArray(new boolean[]{false, true});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBooleanArray");

		Assert.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assert.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assert.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assert.assertTrue(um.hasValue("PrimitiveBooleanArray"));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));
	}

	/**
	 * Bean->UniModel設定 Boolean 配列
	 */
	@Test
	public void setBeanItemValueTest3() {
		final JavaBean bean = new JavaBean();
		bean.setBoolean(Boolean.TRUE);
		bean.setBooleanArray(new Boolean[]{Boolean.FALSE, Boolean.TRUE});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Boolean");
		ModelUtil.setBeanItemValue(um, bean, "BooleanArray");

		Assert.assertTrue(um.containsKey("Boolean"));
		Assert.assertTrue(um.hasValue("Boolean"));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("Boolean"));
		Assert.assertEquals(1, um.getArraySize("Boolean"));
		Assert.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assert.assertFalse(um.isArrayValue("Boolean"));

		Assert.assertTrue(um.containsKey("BooleanArray"));
		Assert.assertTrue(um.hasValue("BooleanArray"));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("BooleanArray"));
		Assert.assertEquals(2, um.getArraySize("BooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("BooleanArray").length);
		Assert.assertTrue(um.isArrayValue("BooleanArray"));
	}


	/**
	 * Bean->UniModel追加 Boolean boolean 空
	 */
	@Test
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.addBeanItemValue(um, bean, "Boolean");
		ModelUtil.addBeanItemValue(um, bean, "BooleanArray");

		Assert.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assert.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assert.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assert.assertTrue(um.hasValue("PrimitiveBooleanArray"));
		Assert.assertNull(um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));

		Assert.assertTrue(um.containsKey("Boolean"));
		Assert.assertTrue(um.hasValue("Boolean"));
		Assert.assertNull(um.getBoolean("Boolean"));
		Assert.assertEquals(1, um.getArraySize("Boolean"));
		Assert.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assert.assertFalse(um.isArrayValue("Boolean"));

		Assert.assertTrue(um.containsKey("BooleanArray"));
		Assert.assertTrue(um.hasValue("BooleanArray"));
		Assert.assertNull(um.getBoolean("BooleanArray"));
		Assert.assertEquals(1, um.getArraySize("BooleanArray"));
		Assert.assertEquals(1, um.getBooleanArray("BooleanArray").length);
		Assert.assertTrue(um.isArrayValue("BooleanArray"));
	}

	/**
	 * Bean->UniModel追加 boolean 配列
	 */
	@Test
	public void addBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setPrimitiveBoolean(true);
		bean.setPrimitiveBooleanArray(new boolean[]{false, true});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBooleanArray");

		Assert.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assert.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assert.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assert.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assert.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assert.assertTrue(um.hasValue("PrimitiveBooleanArray"));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getArraySize("PrimitiveBooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assert.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));
	}

	/**
	 * Bean->UniModel追加 Boolean 配列
	 */
	@Test
	public void addBeanItemValueTest3() {
		final JavaBean bean = new JavaBean();
		bean.setBoolean(Boolean.TRUE);
		bean.setBooleanArray(new Boolean[]{Boolean.FALSE, Boolean.TRUE});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Boolean");
		ModelUtil.addBeanItemValue(um, bean, "BooleanArray");

		Assert.assertTrue(um.containsKey("Boolean"));
		Assert.assertTrue(um.hasValue("Boolean"));
		Assert.assertEquals(Boolean.TRUE, um.getBoolean("Boolean"));
		Assert.assertEquals(1, um.getArraySize("Boolean"));
		Assert.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assert.assertFalse(um.isArrayValue("Boolean"));

		Assert.assertTrue(um.containsKey("BooleanArray"));
		Assert.assertTrue(um.hasValue("BooleanArray"));
		Assert.assertEquals(Boolean.FALSE, um.getBoolean("BooleanArray"));
		Assert.assertEquals(2, um.getArraySize("BooleanArray"));
		Assert.assertEquals(2, um.getBooleanArray("BooleanArray").length);
		Assert.assertTrue(um.isArrayValue("BooleanArray"));
	}


	/**
	 * UniModel→Bean設定 空
	 */
	@Test
	public void setModelValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assert.assertFalse(bean.isPrimitiveBoolean());
		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBoolean());
		Assert.assertNull(bean.isBooleanArray());
	}

	/**
	 * UniModel→Bean設定 Boolean 配列
	 */
	@Test
	public void setModelValueTest2() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", Boolean.TRUE);
		um.setValue("PrimitiveBooleanArray", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("Boolean", Boolean.TRUE);
		um.setValue("BooleanArray", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um);

		Assert.assertTrue(bean.isPrimitiveBoolean());
		Assert.assertFalse(bean.isPrimitiveBooleanArray()[0]);
		Assert.assertTrue(bean.isPrimitiveBooleanArray()[1]);
		Assert.assertEquals(Boolean.TRUE, bean.isBoolean());
		Assert.assertEquals(Boolean.FALSE, bean.isBooleanArray()[0]);
		Assert.assertEquals(Boolean.TRUE, bean.isBooleanArray()[1]);
	}

	/**
	 * UniModel→Bean設定 BooleanからString
	 */
	@Test
	public void setModelValueTest3() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("StringArray", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um);

		Assert.assertEquals("false", bean.getString());
		Assert.assertEquals("false", bean.getStringArray()[0]);
		Assert.assertEquals("true", bean.getStringArray()[1]);
	}


	/**
	 * UniModel→Bean 空
	 */
	@Test
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertFalse(bean.isPrimitiveBoolean());
		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBoolean());
		Assert.assertNull(bean.isBooleanArray());
	}

	/**
	 * UniModel→Bean Boolean配列
	 */
	@Test
	public void setModelValueTest11() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("Boolean", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertTrue(bean.isPrimitiveBoolean());
		Assert.assertEquals(Boolean.TRUE, bean.isBoolean());
		Assert.assertNull(bean.isPrimitiveBooleanArray());
		Assert.assertNull(bean.isBooleanArray());
	}

	/**
	 * UniModel→Bean BooleanからString
	 */
	@Test
	public void setModelValueTest12() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		ModelUtil.setModelValue(bean, um, 1);

		Assert.assertEquals("true", bean.getString());
		Assert.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean BooleanからString
	 */
	@Test
	public void setModelValueTest31() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray(new String[]{"String"});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", new Boolean[]{Boolean.FALSE, Boolean.TRUE});
		um.setValue("StringArray", new Boolean[]{Boolean.TRUE, Boolean.FALSE});

		ModelUtil.setModelValue(bean, um, 2);

		Assert.assertEquals("String", bean.getString());
		Assert.assertNotNull(bean.getStringArray());
		Assert.assertEquals(2, bean.getStringArray().length);
		Assert.assertEquals("true", bean.getStringArray()[0]);
		Assert.assertEquals("false", bean.getStringArray()[1]);
	}
}
