package online.model;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.junit.Assert;
import org.junit.Test;

import test.AssertUtil;

/**
 * TestUniModelNumber
 *
 */
public class TestUniModelNumber {

	/**
	 * testNoValue1
	 */
	@Test
	public void testNoValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertNull(um.getNumber("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getNumberArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.addValue("AAAAA", Integer.valueOf(1));
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(Integer.valueOf(1), um.getNumber("AAAAA"));
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getNumberArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * testNoValue2
	 */
	@Test
	public void testNoValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", BigDecimal.TEN);

		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(BigDecimal.TEN, um.getNumber("AAAAA"));
		Assert.assertEquals(BigDecimal.TEN, um.getNumberArray("AAAAA")[0]);
		Assert.assertEquals(1, um.getArraySize("AAAAA"));
		Assert.assertEquals(1, um.getNumberArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.noValue("AAAAA");
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertNull(um.getNumber("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getNumberArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));

		um.addValue("AAAAA", BigDecimal.ONE);
		um.addValue("AAAAA", BigDecimal.ZERO);
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertTrue(um.hasValue("AAAAA"));
		Assert.assertEquals(2, um.getArraySize("AAAAA"));
		Assert.assertEquals(2, um.getNumberArray("AAAAA").length);
		Assert.assertEquals(BigDecimal.ONE, um.getNumberArray("AAAAA")[0]);
		Assert.assertEquals(BigDecimal.ZERO, um.getNumberArray("AAAAA")[1]);
		Assert.assertTrue(um.isArrayValue("AAAAA"));
	}


	/**
	 * testAliasKey0
	 */
	@Test
	public void testAliasKey0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assert.assertTrue(um.containsKey("BBBBB"));
		Assert.assertTrue(um.containsKey("AAAAA"));
		Assert.assertFalse(um.hasValue("AAAAA"));
		Assert.assertNull(um.getNumber("AAAAA"));
		Assert.assertEquals(0, um.getArraySize("AAAAA"));
		Assert.assertEquals(0, um.getNumberArray("AAAAA").length);
		Assert.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * testAliasKey1
	 */
	@Test
	public void testAliasKey1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Integer)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey2
	 */
	@Test
	public void testAliasKey2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Integer[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey3
	 */
	@Test
	public void testAliasKey3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Long)null);
		um.addValue("bbbbb", (Long)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey4
	 */
	@Test
	public void testAliasKey4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new Boolean[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey5
	 */
	@Test
	public void testAliasKey5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (BigInteger)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (BigInteger)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertNull(um.getNumberArray("aaaaa")[1]);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getNumberArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getNumberArray("bbbbb").length);
		Assert.assertFalse(um.isArrayValue("bbbbb"));
	}

	/**
	 * testAliasKey6
	 */
	@Test
	public void testAliasKey6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Short[])null);
		um.addValue("bbbbb", (Short)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey7
	 */
	@Test
	public void testAliasKey7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Float[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new Float[]{Float.valueOf(1.0F), Float.valueOf(2.05F)});
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(Float.valueOf(1.0F), um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(Float.valueOf(2.05F), um.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getNumberArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getNumberArray("bbbbb").length);
		Assert.assertTrue(um.isArrayValue("bbbbb"));
	}

	/**
	 * testAliasKey8
	 */
	@Test
	public void testAliasKey8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Double[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Double)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		Assert.assertTrue(um.containsKey("bbbbb"));
		Assert.assertTrue(um.hasValue("bbbbb"));
		Assert.assertNull(um.getNumberArray("bbbbb")[0]);
		Assert.assertEquals(1, um.getArraySize("bbbbb"));
		Assert.assertEquals(1, um.getNumberArray("bbbbb").length);
		Assert.assertTrue(um.isArrayValue("bbbbb"));
	}


	/**
	 * testArraySize1
	 */
	@Test
	public void testArraySize1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize2
	 */
	@Test
	public void testArraySize2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertFalse(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(0, um.getArraySize("aaaaa"));
		Assert.assertEquals(0, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize3
	 */
	@Test
	public void testArraySize3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Short)null);
		um.addValue("aaaaa", (Short)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize4
	 */
	@Test
	public void testArraySize4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new BigInteger[]{null});

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize5
	 */
	@Test
	public void testArraySize5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (BigDecimal)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (BigDecimal)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize6
	 */
	@Test
	public void testArraySize6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigInteger[])null);
		um.addValue("aaaaa", (BigInteger)null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumber("aaaaa"));
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize7
	 */
	@Test
	public void testArraySize7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Integer[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new Integer[]{Integer.valueOf(100), Integer.valueOf(200)});
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertEquals(Integer.valueOf(100), um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(Integer.valueOf(200), um.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(3, um.getArraySize("aaaaa"));
		Assert.assertEquals(3, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize8
	 */
	@Test
	public void testArraySize8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long[])null);

		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[0]);
		Assert.assertEquals(1, um.getArraySize("aaaaa"));
		Assert.assertEquals(1, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Long)null);
		Assert.assertTrue(um.containsKey("aaaaa"));
		Assert.assertTrue(um.hasValue("aaaaa"));
		Assert.assertNull(um.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(2, um.getArraySize("aaaaa"));
		Assert.assertEquals(2, um.getNumberArray("aaaaa").length);
		Assert.assertTrue(um.isArrayValue("aaaaa"));
	}


	/**
	 * testcopyValue0
	 */
	@Test
	public void testcopyValue0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue1
	 */
	@Test
	public void testcopyValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue2
	 */
	@Test
	public void testcopyValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Float[])null);
		um.setValue("bbbbb", new Float[0]);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue3
	 */
	@Test
	public void testcopyValue3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Double)null);
		um.addValue("aaaaa", (Double)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue4
	 */
	@Test
	public void testcopyValue4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new BigInteger[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue5
	 */
	@Test
	public void testcopyValue5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (BigDecimal)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (BigDecimal)null);
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue6
	 */
	@Test
	public void testcopyValue6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer[])null);
		um.addValue("aaaaa", (Integer)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue7
	 */
	@Test
	public void testcopyValue7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new Long[]{Long.valueOf(12354566777L), Long.valueOf(-23456L)});
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getNumberArray("aaaaa")[2], um1.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue8
	 */
	@Test
	public void testcopyValue8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Short[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Short)null);
		um.copyValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testputValue0
	 */
	@Test
	public void testputValue0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue1
	 */
	@Test
	public void testputValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigDecimal)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue2
	 */
	@Test
	public void testputValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigInteger[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue3
	 */
	@Test
	public void testputValue3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);
		um.addValue("aaaaa", (Byte)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue4
	 */
	@Test
	public void testputValue4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Double[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue5
	 */
	@Test
	public void testputValue5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Float)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Float)null);
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue6
	 */
	@Test
	public void testputValue6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer[])null);
		um.addValue("aaaaa", (Integer)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue7
	 */
	@Test
	public void testputValue7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Short[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new Short[]{Short.valueOf((short)123), Short.valueOf((short)223)});
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getNumberArray("aaaaa")[2], um1.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue8
	 */
	@Test
	public void testputValue8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Long)null);
		um.putValueTo(um1, "aaaaa");

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testputAll0
	 */
	@Test
	public void testputAll0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll1
	 */
	@Test
	public void testputAll1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigDecimal)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll2
	 */
	@Test
	public void testputAll2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (BigInteger[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll3
	 */
	@Test
	public void testputAll3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Byte)null);
		um.addValue("aaaaa", (Byte)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll4
	 */
	@Test
	public void testputAll4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Float[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll5
	 */
	@Test
	public void testputAll5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Double)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Double)null);
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll6
	 */
	@Test
	public void testputAll6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer[])null);
		um.addValue("aaaaa", (Integer)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll7
	 */
	@Test
	public void testputAll7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Byte[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", new Byte[]{Byte.valueOf((byte)0x10), Byte.valueOf((byte)0x20)});
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getNumberArray("aaaaa")[2], um1.getNumberArray("aaaaa")[2]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll8
	 */
	@Test
	public void testputAll8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Short[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Short)null);
		um1.putAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa")[1], um1.getNumberArray("aaaaa")[1]);
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testaddAll0
	 */
	@Test
	public void testaddAll0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		AssertUtil.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		AssertUtil.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assert.assertEquals(um.getNumberArray("aaaaa").length, um1.getNumberArray("aaaaa").length);
		Assert.assertEquals(um.getNumber("aaaaa"), um1.getNumber("aaaaa"));
		Assert.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		AssertUtil.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll1
	 */
	@Test
	public void testaddAll1() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (BigDecimal)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getNumberArray("aaaaa")[0]);
		Assert.assertNull(um1.getNumber("aaaaa"));
		Assert.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll2
	 */
	@Test
	public void testaddAll2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Integer)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(1, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getNumberArray("aaaaa")[0]);
		Assert.assertNull(um1.getNumber("aaaaa"));
		Assert.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll3
	 */
	@Test
	public void testaddAll3() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Long)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (Long)null);
		um1.addAll(um);

		Assert.assertTrue(um1.containsKey("aaaaa"));
		Assert.assertTrue(um1.hasValue("aaaaa"));
		Assert.assertEquals(2, um1.getArraySize("aaaaa"));
		Assert.assertNull(um1.getNumberArray("aaaaa")[0]);
		Assert.assertNull(um1.getNumberArray("aaaaa")[1]);
		Assert.assertNull(um1.getNumber("aaaaa"));
		Assert.assertTrue(um1.isArrayValue("aaaaa"));
	}
}
