package org.apache.commons.chain2.testutils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.chain2.Catalog;
import org.apache.commons.chain2.Command;
import org.apache.commons.chain2.Context;

/**
 * @version $Id$
 * @param <K> K
 * @param <V> V
 * @param <C> C
 */
public class TestCatalog<K, V, C extends Context<K, V>> implements Catalog<K, V, C> {

    Map<String, Command<K, V, C>> commands = new HashMap<>();

    /**
     * @see org.apache.commons.chain2.Catalog#addCommand(
     * java.lang.String, org.apache.commons.chain2.Command)
     */
    @Override
    public <CMD extends Command<K, V, C>> void addCommand(String name, CMD command) {
        commands.put(name, command);
    }

    /**
     * @see org.apache.commons.chain2.Catalog#getCommand(java.lang.String)
     */
    @Override
    public <CMD extends Command<K, V, C>> CMD getCommand(String name) {
        return (CMD) commands.get(name);
    }

    /**
     * @see org.apache.commons.chain2.Catalog#getNames()
     */
    @Override
    public Iterator<String> getNames() {
        return commands.keySet().iterator();
    }

}
