/*
 * $Id: TestWrappingLookupCommand.java 471754 2006-11-06 14:55:09Z husted $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts.chain.commands.generic;

import junit.framework.TestCase;

import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.impl.ContextBase;
import org.apache.commons.chain2.web.servlet.ServletWebContextBase;
import org.apache.struts.chain.contexts.ServletActionContext;

/** JUnitTest case for class: org.apache.struts.chain.commands.generic.WrappingLookupCommand */
public class TestWrappingLookupCommand extends TestCase {
    /** @param _name String */
    public TestWrappingLookupCommand(String _name) {
        super(_name);
    }
    /** setUp method for test case */
    @Override protected void setUp() {
        return;
    }
    /** tearDown method for test case */
    @Override protected void tearDown() {
        return;
    }
    /** @throws Exception Exception */
    public void testSame() throws Exception {
        WrappingLookupCommand command = new WrappingLookupCommand();
        Context<String, Object> testContext = new ContextBase();

        Context<String, Object> wrapped = command.getContext(testContext);

        assertNotNull(wrapped);
        assertSame(testContext, wrapped);
    }
    /** @throws Exception Exception */
    public void testWrapContextSubclass()
        throws Exception {
        WrappingLookupCommand command = new WrappingLookupCommand();

        command.setWrapperClassName(ServletActionContext.class.getName());

        Context<String, Object> testContext = new ServletWebContextBase();

        Context<String, Object> wrapped = command.getContext(testContext);

        assertNotNull(wrapped);
        assertTrue(wrapped instanceof ServletActionContext);
    }
    /* Executes the test case */
    /** @param argv String[] */
    public static void main(String[] argv) {
        String[] testCaseList = { TestWrappingLookupCommand.class.getName() };

        junit.textui.TestRunner.main(testCaseList);
    }
}
