/*
 * Decompiled with CFR 0.152.
 */
package miragecrops6.crop;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public final class CropCardMirageCrops
extends CropCard {
    private String owner = "MirageCrops6";
    private String name;
    private int tier;
    private String discoveredBy;
    private int maxSize;
    private int[] stats;
    private String[] attributes;
    public IntFunction<String> lambda_getSpriteName = n -> "MirageCrops6:crop/" + this.name() + "." + n;
    public Function<ICropTile, IIcon> lambda_getSprite = iCropTile -> super.getSprite((ICropTile)iCropTile);
    public Predicate<ICropTile> lambda_canGrow = iCropTile -> iCropTile.getSize() < this.maxSize();
    public ToIntFunction<ICropTile> lambda_growthDuration = iCropTile -> super.growthDuration((ICropTile)iCropTile);
    public ToIntFunction<ICropTile> lambda_getOptimalHavestSize = iCropTile -> this.maxSize() + 1;
    public Predicate<ICropTile> lambda_canBeHarvested = iCropTile -> false;
    public Function<ICropTile, ItemStack> lambda_getGain = iCropTile -> null;
    public ToIntFunction<ICropTile> lambda_getSizeAfterHarvest = iCropTile -> super.getSizeAfterHarvest((ICropTile)iCropTile);
    public BiConsumer<ICropTile, Entity> lambda_onCollisionEntity = (iCropTile, entity) -> {};
    public BiConsumer<ICropTile, EntityLivingBase> lambda_onCollisionEntityLiving = (iCropTile, entityLivingBase) -> {};
    public BiPredicate<ICropTile, Entity> lambda_isSprintingResister = (iCropTile, entity) -> false;
    public BiConsumer<ICropTile, EntityPlayer> lambda_onLeftClick = (iCropTile, entityPlayer) -> {};
    public BiPredicate<ICropTile, EntityPlayer> lambda_isLeftClickCanceled = (iCropTile, entityPlayer) -> false;
    public BiConsumer<ICropTile, EntityPlayer> lambda_onRightClick = (iCropTile, entityPlayer) -> {};
    public BiPredicate<ICropTile, EntityPlayer> lambda_isRightClickCanceled = (iCropTile, entityPlayer) -> false;
    public Consumer<ICropTile> lambda_tick = iCropTile -> {};
    public ToIntFunction<ICropTile> lambda_emitRedstone = iCropTile -> super.emitRedstone((ICropTile)iCropTile);
    public ToIntFunction<ICropTile> lambda_getEmittedLight = iCropTile -> super.getEmittedLight((ICropTile)iCropTile);

    public CropCardMirageCrops(CropCardMirageCropsParameter parameterObject) {
        this.name = parameterObject.name;
        this.tier = parameterObject.tier;
        this.discoveredBy = "Mirrgie Riana";
        this.maxSize = parameterObject.maxSize;
        this.stats = parameterObject.stats;
        this.attributes = parameterObject.atributes;
    }

    @Override
    public String owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String displayName() {
        return "crop." + this.owner() + ":" + this.name() + ".name";
    }

    @Override
    public int tier() {
        return this.tier;
    }

    @Override
    public String discoveredBy() {
        return this.discoveredBy;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public int stat(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.stats.length) {
            return 0;
        }
        return this.stats[n];
    }

    @Override
    public String[] attributes() {
        return this.attributes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
        this.textures = new IIcon[this.maxSize()];
        for (int i = 1; i <= this.textures.length; ++i) {
            this.textures[i - 1] = iconRegister.func_94245_a(this.getSpriteName(i));
        }
    }

    public String getSpriteName(int size) {
        return this.lambda_getSpriteName.apply(size);
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        return this.lambda_getSprite.apply(crop);
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return this.lambda_canGrow.test(crop);
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return this.lambda_growthDuration.applyAsInt(crop);
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.lambda_getOptimalHavestSize.applyAsInt(crop);
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return this.lambda_canBeHarvested.test(crop);
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return this.lambda_getGain.apply(crop);
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return (byte)this.lambda_getSizeAfterHarvest.applyAsInt(crop);
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        this.lambda_onCollisionEntity.accept(crop, entity);
        if (entity instanceof EntityLivingBase) {
            this.lambda_onCollisionEntityLiving.accept(crop, (EntityLivingBase)entity);
        }
        if (this.lambda_isSprintingResister.test(crop, entity)) {
            return false;
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public boolean leftclick(ICropTile crop, EntityPlayer player) {
        this.lambda_onLeftClick.accept(crop, player);
        if (this.lambda_isLeftClickCanceled.test(crop, player)) {
            return false;
        }
        return super.leftclick(crop, player);
    }

    @Override
    public boolean rightclick(ICropTile crop, EntityPlayer player) {
        this.lambda_onRightClick.accept(crop, player);
        if (this.lambda_isRightClickCanceled.test(crop, player)) {
            return false;
        }
        return super.rightclick(crop, player);
    }

    @Override
    public void tick(ICropTile crop) {
        this.lambda_tick.accept(crop);
        super.tick(crop);
    }

    @Override
    public int emitRedstone(ICropTile crop) {
        return this.lambda_emitRedstone.applyAsInt(crop);
    }

    @Override
    public int getEmittedLight(ICropTile crop) {
        return this.lambda_getEmittedLight.applyAsInt(crop);
    }

    public static class CropCardMirageCropsParameter {
        public String name;
        public int tier;
        public int maxSize;
        public int[] stats;
        public String[] atributes;

        public CropCardMirageCropsParameter(String name, int tier, int maxSize, int[] stats, String[] atributes) {
            this.name = name;
            this.tier = tier;
            this.maxSize = maxSize;
            this.stats = stats;
            this.atributes = atributes;
        }
    }
}

