/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.entities.parts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.Part;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Cart;
import mirrg.simulation.cart.almandine.factory.entities.primaries.RailBase;
import mirrg.simulation.cart.almandine.gui.property.IDialogProperty;

public abstract class StationBase
extends Part {
    public int x;
    public int y;
    public int radius;

    @Deprecated
    public StationBase() {
    }

    public StationBase(Factory factory, int x, int y, int radius) {
        super(factory);
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    @Override
    public boolean isHover(Factory factory, int x, int y) {
        int dist2 = (x - this.x) * (x - this.x) + (y - this.y) * (y - this.y);
        if (dist2 < (this.radius - 4) * (this.radius - 4)) {
            return false;
        }
        return dist2 < (this.radius + 4) * (this.radius + 4);
    }

    @Override
    public void render(Factory factory, Graphics2D graphics) {
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(this.getColor()));
        graphics.draw(new Ellipse2D.Double(this.x - this.radius, this.y - this.radius, this.radius * 2, this.radius * 2));
        graphics.setStroke(stroke);
    }

    protected abstract int getColor();

    @Override
    public void renderHover(Factory factory, Graphics2D graphics) {
        int radius = this.radius + 4;
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(8125570));
        graphics.draw(new Ellipse2D.Double(this.x - radius, this.y - radius, radius * 2, radius * 2));
        graphics.setStroke(stroke);
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    @Override
    public Point getPoint(Factory factory) throws IllegalEntityIdException {
        return new Point(this.x, this.y);
    }

    public int freeOrder(Factory factory) {
        OptionalInt max = this.getCarts(factory).mapToInt(cart -> ((Cart.PositionStation)cart.position).order).max();
        return max.isPresent() ? max.getAsInt() + 1 : 0;
    }

    @Override
    protected void addProperty(Factory factory, IDialogProperty dialogProperty) {
        super.addProperty(factory, dialogProperty);
        dialogProperty.addPropertyInt("X", "px", () -> this.x, x -> {
            this.x = x;
            return true;
        });
        dialogProperty.addPropertyInt("Y", "px", () -> this.y, y -> {
            this.y = y;
            return true;
        });
        dialogProperty.addPropertyInt("Radius", "px", () -> this.radius, radius -> {
            this.radius = radius;
            return true;
        });
    }

    public Optional<RailBase> getRail(Factory factory, Direction direction) {
        return this.getRails(factory).min((a, b) -> (int)Math.signum(this.getRailAngleGap(factory, (RailBase)a, direction) - this.getRailAngleGap(factory, (RailBase)b, direction)));
    }

    private double getRailAngleGap(Factory factory, RailBase rail, Direction direction) {
        try {
            double angle = rail.getAngle(factory);
            if (rail.idEnd == this.getId()) {
                angle += Math.PI;
            }
            angle -= direction.angle;
            while (angle < -Math.PI) {
                angle += Math.PI * 2;
            }
            while (angle > Math.PI) {
                angle -= Math.PI * 2;
            }
            return Math.abs(angle);
        }
        catch (IllegalEntityIdException e) {
            return Math.PI * 2;
        }
    }

    public Stream<RailBase> getRails(Factory factory) {
        return factory.rails.stream().filter(rail -> rail.idBegin == this.getId() || rail.idEnd == this.getId());
    }

    public void emitCart(Factory factory, Cart cart, RailBase rail) {
        cart.position = rail.idBegin == this.getId() ? new Cart.PositionRail(rail.getId(), 0.0, true) : new Cart.PositionRail(rail.getId(), 1.0, false);
        this.updateOrder(factory);
    }

    protected void updateOrder(Factory factory) {
        int[] order = new int[]{0};
        this.getCarts(factory).forEach(cart -> {
            ((Cart.PositionStation)cart.position).order = order[0];
            nArray[0] = order[0] + 1;
        });
    }

    public Stream<Cart> getCarts(Factory factory) {
        return factory.carts.stream().filter(cart -> cart.position instanceof Cart.PositionStation).filter(cart -> ((Cart.PositionStation)cart.position).idStation == this.getId()).sorted((a, b) -> ((Cart.PositionStation)a.position).order - ((Cart.PositionStation)b.position).order);
    }

    public Optional<Cart> getCartPrimary(Factory factory) {
        return this.getCarts(factory).findFirst();
    }

    public static enum Direction {
        UNDEFINED(0.0),
        RIGHT(0.0),
        UP_RIGHT(-0.7853981633974483),
        UP(-1.5707963267948966),
        UP_LEFT(-2.356194490192345),
        LEFT(-Math.PI),
        DOWN_LEFT(-3.9269908169872414),
        DOWN(-4.71238898038469),
        DOWN_RIGHT(-5.497787143782138);

        public final double angle;

        private Direction(double angle) {
            this.angle = angle;
        }
    }
}

