/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IStackSlab;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.parts.SlotBase;
import mirrg.simulation.cart.almandine.factory.primaries.PrimaryConnection;

public class Arm
extends PrimaryConnection<SlotBase> {
    public double position = 0.0;
    public double duration;
    public IStackSlab stack = null;

    @Deprecated
    public Arm() {
    }

    public Arm(Factory factory, SlotBase begin, SlotBase end, double duration) {
        super(factory, begin, end);
        this.duration = duration;
        this.stack = factory.createStackSlab();
    }

    @Override
    protected SlotBase castEntity(Entity entity) {
        if (entity instanceof SlotBase) {
            return (SlotBase)entity;
        }
        return null;
    }

    @Override
    public void tick(Factory factory, double deltaSecond) throws IllegalEntityIdException {
        if (this.stack.getAmount() >= 1) {
            this.position += deltaSecond;
            if (this.position >= this.duration) {
                ((SlotBase)this.getEntity(factory, this.idEnd)).getSlotSlab(factory).ifPresent(slotSlab -> slotSlab.tryPush(this.stack));
                this.position = this.duration;
            }
        } else {
            this.position -= deltaSecond;
            if (this.position <= 0.0) {
                ((SlotBase)this.getEntity(factory, this.idBegin)).getSlotSlab(factory).ifPresent(slotSlab -> {
                    this.stack = slotSlab.tryPop(1);
                });
                this.position = 0.0;
            }
        }
    }

    @Override
    public void renderBody(Factory factory, Graphics2D graphics) throws IllegalEntityIdException {
        Point begin = ((SlotBase)this.getEntity(factory, this.idBegin)).getPoint(factory);
        Point end = ((SlotBase)this.getEntity(factory, this.idEnd)).getPoint(factory);
        Color c = new Color(35071);
        graphics.setColor(c);
        this.drawMargined(graphics, factory, begin, end, 0.0, 1.0);
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(c);
        graphics.draw(new Ellipse2D.Double(begin.x - 5, begin.y - 5, 10.0, 10.0));
        graphics.setStroke(stroke);
        double angle = Math.atan2(end.y - begin.y, end.x - begin.x);
        Stroke stroke2 = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(c);
        graphics.draw(new Line2D.Double(end.x, end.y, (double)end.x - 5.0 * Math.sin(angle) - 8.0 * Math.cos(angle), (double)end.y - 8.0 * Math.sin(angle) + 5.0 * Math.cos(angle)));
        graphics.draw(new Line2D.Double(end.x, end.y, (double)end.x + 5.0 * Math.sin(angle) - 8.0 * Math.cos(angle), (double)end.y - 8.0 * Math.sin(angle) - 5.0 * Math.cos(angle)));
        graphics.setStroke(stroke2);
        double radius = 3.0;
        graphics.setColor(new Color(0xDD9900));
        graphics.fill(new Ellipse2D.Double((double)begin.x + this.position / this.duration * (double)(end.x - begin.x) - radius, (double)begin.y + this.position / this.duration * (double)(end.y - begin.y) - radius, radius * 2.0, radius * 2.0));
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyDouble("Position", () -> this.position, position -> {
            if (position <= 0.0) {
                return false;
            }
            this.position = position;
            return true;
        });
        frameProperty.addPropertyDouble("Duration", () -> this.duration, duration -> {
            if (duration <= 0.0) {
                return false;
            }
            this.duration = duration;
            return true;
        });
        this.stack.addProperty(factory, frameProperty);
    }

    @Override
    protected double getMarginBegin(Factory factory) {
        return 5.0;
    }

    @Override
    protected double getMarginEnd(Factory factory) {
        return 0.0;
    }
}

