/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.factory.Bound;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.FrameProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.parts.Gauge;
import mirrg.simulation.cart.almandine.factory.parts.SlotBase;
import mirrg.simulation.cart.almandine.factory.parts.Station;
import mirrg.simulation.cart.almandine.factory.primaries.Primary;

public abstract class Furniture
extends Primary {
    public Bound bound;

    @Deprecated
    public Furniture() {
    }

    public Furniture(Factory factory, Bound bound) {
        super(factory);
        this.bound = bound;
    }

    public Stream<SlotBase> getSlots() {
        return Stream.empty();
    }

    public Stream<Gauge> getGauges() {
        return Stream.empty();
    }

    public Stream<Station> getStations() {
        return Stream.empty();
    }

    public void move(int dx, int dy) {
        this.getSlots().forEach(slot -> slot.move(dx, dy));
        this.getGauges().forEach(gauge -> gauge.move(dx, dy));
        this.getStations().forEach(station -> station.move(dx, dy));
        this.bound = this.bound.translate(dx, dy);
    }

    @Override
    public void tick(Factory factory, double deltaSecond) {
        Consumer<Entity> consumer = entity -> {
            try {
                entity.tick(factory, deltaSecond);
            }
            catch (IllegalEntityIdException e) {
                // empty catch block
            }
        };
        this.getSlots().forEach(consumer);
        this.getGauges().forEach(consumer);
        this.getStations().forEach(consumer);
    }

    @Override
    public void render(Factory factory, Graphics2D graphics) {
        this.renderBody(factory, graphics);
        if (this.selected) {
            this.renderSelectMarker(factory, graphics);
        }
        this.getSlots().forEach(entity -> this.render((Entity)entity, factory, graphics));
        this.getGauges().forEach(entity -> this.render((Entity)entity, factory, graphics));
        this.getStations().forEach(entity -> this.render((Entity)entity, factory, graphics));
    }

    private void render(Entity entity, Factory factory, Graphics2D graphics) {
        try {
            entity.render(factory, graphics);
        }
        catch (IllegalEntityIdException e) {
            // empty catch block
        }
    }

    @Override
    public void renderHover(Factory factory, Graphics2D graphics) {
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(8125570));
        graphics.draw(this.bound.grow(5).createShape());
        graphics.setStroke(stroke);
    }

    protected abstract void renderBody(Factory var1, Graphics2D var2);

    protected void renderSelectMarker(Factory factory, Graphics2D graphics) {
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(255, 128, 0));
        graphics.draw(this.bound.grow(5).createShape());
        graphics.setStroke(stroke);
    }

    @Override
    public boolean isHover(Factory factory, int x, int y) {
        return this.bound.contains(x, y);
    }

    @Override
    protected void addProperty(Factory factory, FrameProperty frameProperty) {
        super.addProperty(factory, frameProperty);
        frameProperty.addPropertyInt("X", () -> this.bound.getX(), x -> {
            this.bound = new Bound(x, this.bound.getY(), this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        frameProperty.addPropertyInt("Y", () -> this.bound.getY(), y -> {
            this.bound = new Bound(this.bound.getX(), y, this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        frameProperty.addPropertyInt("Width", () -> this.bound.getWidth(), width -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), width, this.bound.getHeight());
            return true;
        });
        frameProperty.addPropertyInt("Height", () -> this.bound.getHeight(), height -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), this.bound.getWidth(), height);
            return true;
        });
    }

    @Override
    public Point getPoint(Factory factory) throws IllegalEntityIdException {
        return this.bound.getCenter();
    }
}

