/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui.toolcursors;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Furniture;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.simulation.cart.almandine.gui.ToolCursor;

public class ToolCursorMove
extends ToolCursor {
    private Point begin;
    private Point end;

    public ToolCursorMove(FrameMain frameMain) {
        super(frameMain);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.begin = new Point(this.frameMain.getXCoord(e), this.frameMain.getYCoord(e));
        this.end = new Point(this.frameMain.getXCoord(e), this.frameMain.getYCoord(e));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point now = new Point(this.frameMain.getXCoord(e), this.frameMain.getYCoord(e));
        this.frameMain.getFactory().getSelecteds().forEach(primary -> {
            if (primary instanceof Furniture) {
                ((Furniture)primary).move(point.x - this.end.x, point.y - this.end.y);
            }
        });
        this.end = now;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.begin = null;
        this.end = null;
    }

    public String toString() {
        return "\u79fb\u52d5";
    }

    @Override
    public void render(Graphics2D graphics) {
        if (this.begin == null) {
            return;
        }
        if (this.end == null) {
            return;
        }
        this.frameMain.pushTanslate(graphics);
        graphics.setColor(new Color(0xFF0000));
        graphics.drawLine(this.begin.x, this.begin.y, this.end.x, this.end.y);
        this.frameMain.popTanslate(graphics);
    }
}

