/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui.toolcursors;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.entities.Entity;
import mirrg.simulation.cart.almandine.factory.entities.parts.StationBase;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Cart;
import mirrg.simulation.cart.almandine.factory.entities.primaries.Rail;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.simulation.cart.almandine.gui.toolcursors.ToolCursorClickPrimaryBase;
import mirrg.swing.helium.logging.HLog;

public class ToolCursorPutCart
extends ToolCursorClickPrimaryBase<Entity> {
    public ToolCursorPutCart(FrameMain frameMain) {
        super(frameMain);
    }

    public String toString() {
        return "\u8a2d\u7f6e\uff1a\u8ca8\u8eca";
    }

    @Override
    protected void action(MouseEvent e, Entity entity) {
        Factory factory = this.frameMain.getFactory();
        if (entity instanceof StationBase) {
            factory.carts.add(new Cart(factory, new Cart.PositionStation(entity.getId(), ((StationBase)entity).freeOrder(factory)), 12, 5.0, 10800.0));
        } else if (entity instanceof Rail) {
            try {
                double position = ((Rail)entity).getPosition(this.frameMain.getFactory(), this.frameMain.getXCoord(e), this.frameMain.getYCoord(e));
                factory.carts.add(new Cart(factory, new Cart.PositionRail(entity.getId(), position, position > 0.5), 12, 5.0, 10800.0));
            }
            catch (IllegalEntityIdException e1) {
                HLog.processException((Exception)e1);
            }
        } else {
            HLog.warning((String)("\u4e0d\u6b63\u306a\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f: " + entity));
        }
    }

    @Override
    protected ArrayList<? extends Entity> getEntities(Factory factory, int x, int y) {
        Collector collector = Collectors.toCollection(() -> new ArrayList());
        return factory.getEntities(x, y).stream().filter(entity -> entity instanceof StationBase || entity instanceof Rail).collect(collector);
    }
}

