package mirrg.simulation.cart.almandine.mods.vanilla;

import static mirrg.swing.helium.GroupBuilder.*;

import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Vector;
import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.swing.helium.DialogMirrg;
import mirrg.swing.helium.GroupBuilder;

public class DialogPropertyToolCursor extends DialogMirrg implements IDialogProperty
{

	private String name;

	public DialogPropertyToolCursor(JFrame frame, String name)
	{
		super(frame, "プロパティ: " + name);
		this.name = name;

		enabledTick = true;

		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
	}

	// groupBuilders変数によりnew時にコンポーネントが確定していないため
	@Override
	protected void componentShown()
	{

		{
			GroupLayout layout = new GroupLayout(getContentPane());

			groupBuilders.add(0, group(new JLabel(name)));

			group(

				(Object[]) groupBuilders.toArray(new GroupBuilder[0])

			).apply(layout);

			layout.setAutoCreateGaps(true);
			layout.setAutoCreateContainerGaps(true);
			setLayout(layout);
		}

		pack();
		{
			Point mouse = MouseInfo.getPointerInfo().getLocation();
			mouse.translate(-getWidth() / 2, -getHeight() / 2);
			setLocation(mouse);
		}
	}

	private ArrayList<GroupBuilder> groupBuilders = new ArrayList<>();

	public void addComponent(GroupBuilder groupBuilder)
	{
		groupBuilders.add(groupBuilder);
	}

	public void addPropertyInt(String name, String unit, IntSupplier getter, IntPredicate setter)
	{
		JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, null, null, 1));

		((JSpinner.DefaultEditor) spinner.getEditor()).getTextField().setColumns(10);

		onTick.add(() -> {
			if (!spinner.isFocusOwner()) {
				spinner.setValue(getter.getAsInt());
			}
		});

		spinner.addChangeListener(e -> {
			int value = ((Number) spinner.getValue()).intValue();
			if (setter.test(value)) {
				spinner.setBackground(Color.white);
			} else {
				spinner.setBackground(new Color(0xffbaba));
			}
			spinner.setValue(value);
		});

		groupBuilders.add(group(
			new JLabel(name),
			spinner,
			new JLabel(" [" + unit + "]")));
	}

	public void addPropertyDouble(String name, String unit, DoubleSupplier getter, DoublePredicate setter)
	{
		JSpinner spinner = new JSpinner(new SpinnerNumberModel(0.0, null, null, 1.0));

		((JSpinner.DefaultEditor) spinner.getEditor()).getTextField().setColumns(10);

		onTick.add(() -> {
			if (!spinner.isFocusOwner()) {
				spinner.setValue(getter.getAsDouble());
			}
		});

		spinner.addChangeListener(e -> {
			double value = ((Number) spinner.getValue()).doubleValue();
			if (setter.test(value)) {
				spinner.setBackground(Color.white);
			} else {
				spinner.setBackground(new Color(0xffbaba));
			}
			spinner.setValue(value);
		});

		groupBuilders.add(group(
			new JLabel(name),
			spinner,
			new JLabel(" [" + unit + "]")));
	}

	public void addPropertyString(String name, Supplier<String> getter, Predicate<String> setter)
	{
		JTextField textField = new JTextField();

		textField.setColumns(10);

		onTick.add(() -> {
			if (!textField.isFocusOwner()) {
				textField.setText(getter.get());
			}
		});

		textField.addActionListener(e -> {
			if (setter.test(textField.getText())) {
				textField.setBackground(Color.white);
			} else {
				textField.setBackground(new Color(0xffbaba));
			}
		});

		groupBuilders.add(group(
			new JLabel(name),
			textField));
	}

	public void addPropertyBoolean(String name, BooleanSupplier getter, Predicate<Boolean> setter)
	{
		JCheckBox checkBox = new JCheckBox(name);

		onTick.add(() -> {
			if (!checkBox.isFocusOwner()) {
				checkBox.setSelected(getter.getAsBoolean());
			}
		});

		checkBox.addActionListener(e -> {
			if (setter.test(checkBox.isSelected())) {
				checkBox.setBackground(Color.white);
			} else {
				checkBox.setBackground(new Color(0xffbaba));
			}
		});

		groupBuilders.add(group(checkBox));
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> void addPropertyComboBox(String name, Stream<T> items, Supplier<T> getter, Predicate<T> setter)
	{
		ArrayList<T> listItem = items.collect(Collectors.toCollection(ArrayList::new));
		JComboBox<T> comboBox = new JComboBox<T>(new Vector<T>(listItem));

		comboBox.addActionListener(e -> {
			setter.test((T) comboBox.getSelectedItem());
		});

		onTick.add(() -> {
			if (!comboBox.isFocusOwner()) {
				comboBox.setSelectedItem(getter.get());
			}
		});

		groupBuilders.add(group(
			new JLabel(name),
			comboBox));
	}

	@Override
	public void open()
	{
		setVisible(true);
	}

}
