package mirrg.simulation.cart.almandine.mods.vanilla;

import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.thermo.StackSlabThermo;

public class ProviderEnvironmentThermo implements IProviderEnvironment
{

	@Override
	public void getEnvironment(Environment environment)
	{
		environment.doubles.put("temperature", 25D);
		environment.doubles.put("temperatureSpawn", 1000D);
		environment.doubles.put("durationHeatHalfLife", 3 * 3600D);
	}

	@Override
	public IStackSlab createStackSlab(int amount, Environment environment)
	{
		return environment.getDouble("temperatureSpawn")
			.map(temperature -> new StackSlabThermo(amount, temperature))
			.orElseGet(() -> new StackSlabThermo(amount, 0));
	}

}
