package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Gauge;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.simulation.cart.almandine.mods.vanilla.slots.SlotModule;

public abstract class FurnitureIO extends Furniture
{

	public SlotModule slot;

	/**
	 * [s]
	 */
	public Gauge gauge;

	@Deprecated
	public FurnitureIO()
	{
		super();
	}

	public FurnitureIO(GameAlmandine game, Point point, double duration) throws IllegalEntityIdException
	{
		super(game, new Bound(point.x - 10, point.y - 40, 20, 50));
		slot = new SlotModule(game, new Bound(point.x - 8, point.y - 8, 16, 16), 1);
		gauge = new Gauge(game, new Bound(point.x - 6, point.y - 36, 12, 24), duration);
	}

	protected Stream<SlotBase> getSlots()
	{
		return Stream.of(slot);
	}

	@Override
	protected Stream<Gauge> getGauges()
	{
		return Stream.of(gauge);
	}

	@Override
	protected void drawBody(Graphics2D graphics)
	{
		graphics.setColor(new Color(getBackColor()));
		graphics.fill(bound.createShape());
		graphics.setColor(new Color(0x404040));
		graphics.draw(bound.grow(1, 1, 0, 0).createShape());
	}

	protected abstract int getBackColor();

}
